/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.gateway.converter.builders;

import com.google.gson.Gson;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.tisdk.carreference.gateway.common.ParamsBuilder;
import ru.tinkoff.tisdk.casco.CascoData;
import ru.tinkoff.tisdk.gateway.Config;
import ru.tinkoff.tisdk.gateway.model.GCascoContact;
import ru.tinkoff.tisdk.gateway.model.GCascoDealDetails;
import ru.tinkoff.tisdk.gateway.model.GCascoVehicle;
import ru.tinkoff.tisdk.gateway.model.GCascoVehicleWrap;
import ru.tinkoff.tisdk.gateway.model.GUpdateCascoModel;
import ru.tinkoff.tisdk.utils.StringUtilsKt;

public class UpdateCascoParamsBuilder
extends ParamsBuilder {
    private CascoData data;
    private String source = Config.getSource();

    public UpdateCascoParamsBuilder(@NotNull CascoData data) {
        this.data = data;
    }

    @Override
    @NotNull
    public String buildBodyParams() {
        if (StringUtilsKt.isEmpty(this.data.getRequestId())) {
            throw new IllegalArgumentException("Casco application id is invalid: " + this.data.getRequestId());
        }
        int referenceId = Double.valueOf(this.data.getVehicle().getDetails().getVehicleId()).intValue();
        return new Gson().toJson((Object)new GUpdateCascoModel(this.data.getRequestId(), this.data.getContact().getFirstName(), this.data.getContact().getLastName(), this.data.getContact().getMiddleName(), this.data.getContact().getPhone().getValue(), this.data.getCity().getRegion(), this.source, new GCascoDealDetails(new GCascoContact[]{new GCascoContact(this.data.getContact().getFirstName(), this.data.getContact().getLastName(), this.data.getContact().getMiddleName(), this.data.getContact().getPhone().getValue())}, new GCascoVehicleWrap[]{new GCascoVehicleWrap(new GCascoVehicle(Integer.valueOf(this.data.getCity().getRegion()), this.data.getVehicle().getProperties().getYear().getIntValue(), this.data.getVehicle().getDetails().getPrice(), referenceId))})));
    }

    @Override
    @NotNull
    public Map<String, String> buildQueryParams() throws Exception {
        return super.buildQueryParams();
    }
}

