/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.gateway.converter.converters;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.tisdk.Deal;
import ru.tinkoff.tisdk.DealResult;
import ru.tinkoff.tisdk.FullQuoteData;
import ru.tinkoff.tisdk.carreference.gateway.common.convertion.Converter;
import ru.tinkoff.tisdk.carreference.gateway.common.convertion.InsuranceResponse;
import ru.tinkoff.tisdk.carreference.gateway.common.convertion.ServerResponse;
import ru.tinkoff.tisdk.gateway.model.GContact;
import ru.tinkoff.tisdk.gateway.model.GDealResult;
import ru.tinkoff.tisdk.gateway.model.GVehicleDocument;
import ru.tinkoff.tisdk.gateway.model.payload.EOsagoUpdatePayload;
import ru.tinkoff.tisdk.subject.Contact;
import ru.tinkoff.tisdk.subject.Driver;
import ru.tinkoff.tisdk.subject.Drivers;
import ru.tinkoff.tisdk.subject.FullDriverLicense;
import ru.tinkoff.tisdk.subject.Insurer;
import ru.tinkoff.tisdk.subject.PartialDriverLicense;
import ru.tinkoff.tisdk.subject.Subject;
import ru.tinkoff.tisdk.utils.DateUtils;
import ru.tinkoff.tisdk.utils.Preconditions;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001#B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00022\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fH\u0002J:\u0010\u0014\u001a\u00020\u0015\"\b\b\u0000\u0010\u0019*\u00020\u001a2\u0010\u0010\u001b\u001a\f\u0012\u0004\u0012\u0002H\u0019\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001d\u001a\u00020\f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001fH\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010!\u001a\u00020\"H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lru/tinkoff/tisdk/gateway/converter/converters/DealConverter;", "Lru/tinkoff/tisdk/carreference/gateway/common/convertion/Converter;", "Lru/tinkoff/tisdk/Deal;", "Lru/tinkoff/tisdk/gateway/model/payload/EOsagoUpdatePayload;", "fullQuoteData", "Lru/tinkoff/tisdk/FullQuoteData;", "(Lru/tinkoff/tisdk/FullQuoteData;)V", "checkSamePerson", "", "driver1", "Lru/tinkoff/tisdk/subject/Driver;", "driver2", "Lru/tinkoff/tisdk/gateway/model/GContact;", "convertPayload", "response", "Lru/tinkoff/tisdk/carreference/gateway/common/convertion/ServerResponse;", "convertResult", "Lru/tinkoff/tisdk/DealResult;", "result", "Lru/tinkoff/tisdk/gateway/model/GDealResult;", "copyData", "", "contact1", "Lru/tinkoff/tisdk/subject/Contact;", "contact2", "T", "Lru/tinkoff/tisdk/subject/PartialDriverLicense;", "subject", "Lru/tinkoff/tisdk/subject/Subject;", "contact", "licenseConverter", "Lru/tinkoff/tisdk/gateway/converter/converters/DealConverter$DriverLicenseConverter;", "parse", "json", "", "DriverLicenseConverter", "tisdk-domain"})
public final class DealConverter
extends Converter<Deal, EOsagoUpdatePayload> {
    private final FullQuoteData fullQuoteData;

    @Override
    @NotNull
    protected ServerResponse<EOsagoUpdatePayload> parse(@NotNull String json) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Object object = new Gson().fromJson(json, new TypeToken<InsuranceResponse<EOsagoUpdatePayload>>(){}.getType());
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Gson().fromJson<ServerRe\u2026pdatePayload>>() {}.type)");
        return (ServerResponse)object;
    }

    @Override
    @NotNull
    protected Deal convertPayload(@NotNull ServerResponse<EOsagoUpdatePayload> response) {
        EOsagoUpdatePayload payload;
        Intrinsics.checkParameterIsNotNull(response, (String)"response");
        EOsagoUpdatePayload eOsagoUpdatePayload = payload = Preconditions.checkNotNull(response.getPayload());
        if (eOsagoUpdatePayload == null) {
            Intrinsics.throwNpe();
        }
        int insurerNumber = eOsagoUpdatePayload.Deal.InsurerNumber;
        int ownerNumber = payload.Deal.VehicleOwnerNumber;
        for (GContact contact : payload.Deal.Contacts) {
            Driver[] driverArray;
            if (contact.getSubjectNumber() == insurerNumber) {
                Insurer insurer = this.fullQuoteData.getInsurer();
                if (insurer == null) {
                    Intrinsics.throwNpe();
                }
                Contact contact2 = insurer;
                GContact gContact = contact;
                Intrinsics.checkExpressionValueIsNotNull((Object)gContact, (String)"contact");
                this.copyData(contact2, gContact);
                continue;
            }
            if (contact.getSubjectNumber() == ownerNumber) {
                Contact contact3 = this.fullQuoteData.getOwner();
                if (contact3 == null) {
                    Intrinsics.throwNpe();
                }
                GContact gContact = contact;
                Intrinsics.checkExpressionValueIsNotNull((Object)gContact, (String)"contact");
                this.copyData(contact3, gContact);
                continue;
            }
            Drivers drivers = this.fullQuoteData.getDrivers();
            if (drivers == null) {
                Intrinsics.throwNpe();
            }
            if (drivers.getDrivers() == null) continue;
            if (this.fullQuoteData.getDrivers().getDrivers() == null) {
                Intrinsics.throwNpe();
            }
            for (Driver driver : driverArray) {
                GContact gContact = contact;
                Intrinsics.checkExpressionValueIsNotNull((Object)gContact, (String)"contact");
                if (!this.checkSamePerson(driver, gContact)) continue;
                this.copyData(driver, contact, new DriverLicenseConverter<FullDriverLicense>(driver){
                    final /* synthetic */ Driver $driver;

                    @NotNull
                    public FullDriverLicense convert(@NotNull GVehicleDocument document) throws Exception {
                        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
                        DriverLicenseType DriverLicenseType = this.$driver.getDriverLicense();
                        if (DriverLicenseType == null) {
                            Intrinsics.throwNpe();
                        }
                        return (FullDriverLicense)DriverLicenseType;
                    }
                    {
                        this.$driver = $captured_local_variable$0;
                    }
                });
            }
        }
        String string = payload.Deal.Id;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"payload.Deal.Id");
        String string2 = payload.Deal.SetDetails.SetNumber;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"payload.Deal.SetDetails.SetNumber");
        GDealResult gDealResult = payload.Deal.SetDetails.OsagoQuote.Result;
        Intrinsics.checkExpressionValueIsNotNull((Object)gDealResult, (String)"payload.Deal.SetDetails.OsagoQuote.Result");
        return new Deal(string, string2, this.convertResult(gDealResult));
    }

    private final DealResult convertResult(GDealResult result) {
        return new DealResult(result.TotalPremium);
    }

    private final <T extends PartialDriverLicense> void copyData(Subject<T, ?> subject, GContact contact, DriverLicenseConverter<T> licenseConverter) {
        subject.setId(contact.getPublicId());
        if (contact.getDocuments() != null) {
            GVehicleDocument[] gVehicleDocumentArray = contact.getDocuments();
            if (gVehicleDocumentArray == null) {
                Intrinsics.throwNpe();
            }
            for (GVehicleDocument document : gVehicleDocumentArray) {
                if (!Intrinsics.areEqual((Object)"DrivingLicense", (Object)document.getType())) continue;
                T driverLicense = licenseConverter.convert(document);
                subject.setDriverLicense(driverLicense);
                break;
            }
        }
    }

    private final void copyData(Contact contact1, GContact contact2) throws Exception {
        this.copyData(contact1, contact2, new DriverLicenseConverter<PartialDriverLicense>(){

            @NotNull
            public PartialDriverLicense convert(@NotNull GVehicleDocument document) throws Exception {
                Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
                String string = document.getSeries();
                String string2 = document.getNumber();
                String string3 = document.getDateIssued();
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                return new PartialDriverLicense(string, string2, DateUtils.parseDate(string3));
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkSamePerson(Driver driver1, GContact driver2) {
        GVehicleDocument license = null;
        if (driver2.getDocuments() != null) {
            GVehicleDocument[] gVehicleDocumentArray = driver2.getDocuments();
            if (gVehicleDocumentArray == null) {
                Intrinsics.throwNpe();
            }
            for (GVehicleDocument document : gVehicleDocumentArray) {
                if (!Intrinsics.areEqual((Object)"DrivingLicense", (Object)document.getType())) continue;
                license = document;
                break;
            }
        }
        if (license == null) return false;
        FullDriverLicense fullDriverLicense = (FullDriverLicense)driver1.getDriverLicense();
        if (!Intrinsics.areEqual((Object)(fullDriverLicense != null ? fullDriverLicense.getSeries() : null), (Object)license.getSeries())) return false;
        FullDriverLicense fullDriverLicense2 = (FullDriverLicense)driver1.getDriverLicense();
        if (!Intrinsics.areEqual((Object)(fullDriverLicense2 != null ? fullDriverLicense2.getNumber() : null), (Object)license.getNumber())) return false;
        if (!Intrinsics.areEqual((Object)driver1.getFirstName(), (Object)driver2.getFirstName())) return false;
        if (!Intrinsics.areEqual((Object)driver1.getLastName(), (Object)driver2.getLastName())) return false;
        if (!Intrinsics.areEqual((Object)driver1.getMiddleName(), (Object)driver2.getMiddleName())) return false;
        return true;
    }

    public DealConverter(@NotNull FullQuoteData fullQuoteData) {
        Intrinsics.checkParameterIsNotNull((Object)fullQuoteData, (String)"fullQuoteData");
        this.fullQuoteData = fullQuoteData;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\"\u0018\u0000*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lru/tinkoff/tisdk/gateway/converter/converters/DealConverter$DriverLicenseConverter;", "T", "Lru/tinkoff/tisdk/subject/PartialDriverLicense;", "", "()V", "convert", "document", "Lru/tinkoff/tisdk/gateway/model/GVehicleDocument;", "(Lru/tinkoff/tisdk/gateway/model/GVehicleDocument;)Lru/tinkoff/tisdk/subject/PartialDriverLicense;", "tisdk-domain"})
    private static abstract class DriverLicenseConverter<T extends PartialDriverLicense> {
        public abstract T convert(@NotNull GVehicleDocument var1) throws Exception;
    }
}

