/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.subject;

import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.address.Address;
import ru.tinkoff.tisdk.subject.PartialDriverLicense;
import ru.tinkoff.tisdk.subject.Passport;
import ru.tinkoff.tisdk.subject.Subject;
import ru.tinkoff.tisdk.utils.StringUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0016\u0018\u0000 &2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001:\u0001&BU\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0000H\u0016J\u0013\u0010\"\u001a\u00020\u001a2\b\u0010#\u001a\u0004\u0018\u00010$H\u0096\u0002J\b\u0010%\u001a\u00020\u0004H\u0016R(\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018\u00a8\u0006'"}, d2={"Lru/tinkoff/tisdk/subject/Contact;", "Lru/tinkoff/tisdk/subject/Subject;", "Lru/tinkoff/tisdk/subject/PartialDriverLicense;", "subjectNumber", "", "fio", "", "birthDate", "Ljava/util/Date;", "gender", "Lru/tinkoff/tisdk/subject/Subject$Gender;", "passport", "Lru/tinkoff/tisdk/subject/Passport;", "registeredAddress", "Lru/tinkoff/tisdk/address/Address;", "homeAddress", "(ILjava/lang/String;Ljava/util/Date;Lru/tinkoff/tisdk/subject/Subject$Gender;Lru/tinkoff/tisdk/subject/Passport;Lru/tinkoff/tisdk/address/Address;Lru/tinkoff/tisdk/address/Address;)V", "value", "email", "getEmail", "()Ljava/lang/String;", "setEmail", "(Ljava/lang/String;)V", "getHomeAddress", "()Lru/tinkoff/tisdk/address/Address;", "isValid", "", "()Z", "getPassport", "()Lru/tinkoff/tisdk/subject/Passport;", "getRegisteredAddress", "copyIds", "", "subject", "equals", "other", "", "hashCode", "Companion", "tisdk-domain"})
public class Contact
extends Subject<PartialDriverLicense, Contact> {
    @Nullable
    private String email;
    @Nullable
    private final Passport passport;
    @Nullable
    private final Address registeredAddress;
    @Nullable
    private final Address homeAddress;
    private static final int FOURTEEN_AGE = 14;
    private static final int TWENTY_AGE = 20;
    private static final int FORTY_FIVE_AGE = 45;
    private static final String EMAIL_REGEXP = "^[A-Z0-9a-z._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,64}$";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String getEmail() {
        return this.email;
    }

    public final void setEmail(@Nullable String value) {
        if (value != null) {
            boolean bl = Companion.validateEmail(value);
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
        this.email = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isValid() {
        if (!super.isValid()) return false;
        Passport passport = this.passport;
        if (passport == null) return false;
        if (!passport.isValid()) return false;
        Address address = this.registeredAddress;
        if (address == null) return false;
        if (!address.isValid()) return false;
        Address address2 = this.homeAddress;
        if (address2 == null) return false;
        if (!address2.isValid()) return false;
        if (!Companion.validateTwentyAge(this.getBirthDate(), this.passport.getDateIssue())) return false;
        if (!Companion.validateFortyFiveAge(this.getBirthDate(), this.passport.getDateIssue())) return false;
        return true;
    }

    @Override
    public void copyIds(@NotNull Contact subject) {
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        super.copyIds((Subject)subject);
        Address address = this.homeAddress;
        if (address != null) {
            Address address2 = subject.homeAddress;
            address.setId(address2 != null ? address2.getId() : null);
        }
        Address address3 = this.registeredAddress;
        if (address3 != null) {
            Address address4 = subject.registeredAddress;
            address3.setId(address4 != null ? address4.getId() : null);
        }
        Passport passport = this.passport;
        if (passport != null) {
            Passport passport2 = subject.passport;
            passport.setId(passport2 != null ? passport2.getId() : null);
        }
        if (subject.getDriverLicense() != null) {
            this.setDriverLicense(subject.getDriverLicense());
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type ru.tinkoff.tisdk.subject.Contact");
        }
        Contact cfr_ignored_0 = (Contact)object2;
        if (Intrinsics.areEqual((Object)this.passport, (Object)((Contact)other).passport) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.registeredAddress, (Object)((Contact)other).registeredAddress) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.homeAddress, (Object)((Contact)other).homeAddress) ^ true);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        Passport passport = this.passport;
        result = 31 * result + (passport != null ? passport.hashCode() : 0);
        Address address = this.registeredAddress;
        result = 31 * result + (address != null ? address.hashCode() : 0);
        Address address2 = this.homeAddress;
        result = 31 * result + (address2 != null ? address2.hashCode() : 0);
        return result;
    }

    @Nullable
    public final Passport getPassport() {
        return this.passport;
    }

    @Nullable
    public final Address getRegisteredAddress() {
        return this.registeredAddress;
    }

    @Nullable
    public final Address getHomeAddress() {
        return this.homeAddress;
    }

    public Contact(int subjectNumber, @Nullable String fio, @Nullable Date birthDate, @Nullable Subject.Gender gender, @Nullable Passport passport, @Nullable Address registeredAddress, @Nullable Address homeAddress) {
        super(subjectNumber, fio, birthDate, gender);
        this.passport = passport;
        this.registeredAddress = registeredAddress;
        this.homeAddress = homeAddress;
        boolean bl = this.registeredAddress == null || this.registeredAddress.getType() == Address.Type.REGISTER;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.homeAddress == null || this.homeAddress.getType() == Address.Type.HOME;
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ Contact(int n, String string, Date date, Subject.Gender gender, Passport passport, Address address, Address address2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            date = null;
        }
        if ((n2 & 8) != 0) {
            gender = null;
        }
        if ((n2 & 0x10) != 0) {
            passport = null;
        }
        if ((n2 & 0x20) != 0) {
            address = null;
        }
        if ((n2 & 0x40) != 0) {
            address2 = null;
        }
        this(n, string, date, gender, passport, address, address2);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004J\u001a\u0010\u0011\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rJ\u001a\u0010\u0012\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rJ\u001a\u0010\u0013\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lru/tinkoff/tisdk/subject/Contact$Companion;", "", "()V", "EMAIL_REGEXP", "", "FORTY_FIVE_AGE", "", "FOURTEEN_AGE", "TWENTY_AGE", "checkAgePassport", "", "checkAge", "birthDate", "Ljava/util/Date;", "issuePassport", "validateEmail", "email", "validateFortyFiveAge", "validateFourteenAge", "validateTwentyAge", "tisdk-domain"})
    public static final class Companion {
        public final boolean validateEmail(@Nullable String email) {
            if (StringUtilsKt.isEmpty(email)) {
                return false;
            }
            Pattern pattern = Pattern.compile(Contact.EMAIL_REGEXP);
            String string = email;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Matcher matcher = pattern.matcher(string);
            return matcher.matches();
        }

        public final boolean validateFourteenAge(@Nullable Date birthDate, @Nullable Date issuePassport) {
            return this.checkAgePassport(14, birthDate, issuePassport);
        }

        public final boolean validateTwentyAge(@Nullable Date birthDate, @Nullable Date issuePassport) {
            return this.checkAgePassport(20, birthDate, issuePassport);
        }

        public final boolean validateFortyFiveAge(@Nullable Date birthDate, @Nullable Date issuePassport) {
            return this.checkAgePassport(45, birthDate, issuePassport);
        }

        private final boolean checkAgePassport(int checkAge, Date birthDate, Date issuePassport) {
            if (birthDate == null || issuePassport == null) {
                return true;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.add(1, -checkAge);
            Calendar calendar2 = calendar;
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"calendar");
            boolean moreThanCheckAge = birthDate.compareTo(calendar2.getTime()) < 0;
            calendar.setTime(birthDate);
            calendar.add(1, checkAge);
            return !moreThanCheckAge || issuePassport.compareTo(calendar.getTime()) >= 0;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

