/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.subject;

import java.util.Calendar;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.subject.FullDriverLicense;
import ru.tinkoff.tisdk.subject.PartialDriverLicense;
import ru.tinkoff.tisdk.subject.Subject;
import ru.tinkoff.tisdk.utils.DateUtils;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00122\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0012BU\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lru/tinkoff/tisdk/subject/Driver;", "Lru/tinkoff/tisdk/subject/Subject;", "Lru/tinkoff/tisdk/subject/FullDriverLicense;", "subjectNumber", "", "fio", "", "birthDate", "Ljava/util/Date;", "gender", "Lru/tinkoff/tisdk/subject/Subject$Gender;", "seriesNumberLicense", "dateIssueLicense", "firstYearIssueLicense", "(ILjava/lang/String;Ljava/util/Date;Lru/tinkoff/tisdk/subject/Subject$Gender;Ljava/lang/String;Ljava/util/Date;Ljava/util/Date;)V", "isValid", "", "()Z", "Companion", "tisdk-domain"})
public final class Driver
extends Subject<FullDriverLicense, Driver> {
    private static final int CORRECT_DRIVER_AGE = 18;
    private static final int DRIVER_LICENSE_VALID_YEARS = 10;
    public static final Companion Companion = new Companion(null);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isValid() {
        if (!super.isValid()) return false;
        FullDriverLicense fullDriverLicense = (FullDriverLicense)this.getDriverLicense();
        if (fullDriverLicense == null) return false;
        if (!fullDriverLicense.isValid()) return false;
        FullDriverLicense fullDriverLicense2 = (FullDriverLicense)this.getDriverLicense();
        if (!Companion.validateDateIssueLicense(fullDriverLicense2 != null ? fullDriverLicense2.getIssueDate() : null, this.getBirthDate())) return false;
        FullDriverLicense fullDriverLicense3 = (FullDriverLicense)this.getDriverLicense();
        FullDriverLicense fullDriverLicense4 = (FullDriverLicense)this.getDriverLicense();
        if (!Companion.validateFirstYearIssueLicense(fullDriverLicense3 != null ? fullDriverLicense3.getFirstYearIssueDate() : null, fullDriverLicense4 != null ? fullDriverLicense4.getIssueDate() : null, this.getBirthDate())) return false;
        return true;
    }

    public Driver(int subjectNumber, @Nullable String fio, @Nullable Date birthDate, @Nullable Subject.Gender gender, @Nullable String seriesNumberLicense, @Nullable Date dateIssueLicense, @Nullable Date firstYearIssueLicense) {
        super(subjectNumber, fio, birthDate, gender);
        this.setDriverLicense((PartialDriverLicense)new FullDriverLicense(seriesNumberLicense, dateIssueLicense, firstYearIssueLicense));
    }

    public /* synthetic */ Driver(int n, String string, Date date, Subject.Gender gender, String string2, Date date2, Date date3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            date = null;
        }
        if ((n2 & 8) != 0) {
            gender = null;
        }
        if ((n2 & 0x10) != 0) {
            string2 = null;
        }
        if ((n2 & 0x20) != 0) {
            date2 = null;
        }
        if ((n2 & 0x40) != 0) {
            date3 = null;
        }
        this(n, string, date, gender, string2, date2, date3);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\tJ$\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\t2\b\u0010\r\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lru/tinkoff/tisdk/subject/Driver$Companion;", "", "()V", "CORRECT_DRIVER_AGE", "", "DRIVER_LICENSE_VALID_YEARS", "validateDateIssueLicense", "", "dateIssueLicense", "Ljava/util/Date;", "birthDate", "validateFirstYearIssueLicense", "firstDateIssueLicense", "lastDateIssueLicense", "tisdk-domain"})
    public static final class Companion {
        public final boolean validateDateIssueLicense(@Nullable Date dateIssueLicense, @Nullable Date birthDate) {
            Calendar c;
            if (dateIssueLicense == null) {
                return false;
            }
            boolean ageValid = true;
            if (birthDate != null) {
                Calendar calendar = c = Calendar.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"c");
                calendar.setTime(birthDate);
                c.add(1, 18);
                ageValid = dateIssueLicense.compareTo(c.getTime()) >= 0;
            }
            Calendar calendar = c = Calendar.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"c");
            calendar.setTime(dateIssueLicense);
            c.add(1, 10);
            Date now = new Date();
            boolean issueDateValid = dateIssueLicense.compareTo(now) <= 0 && c.getTime().compareTo(now) > 0;
            return ageValid && issueDateValid;
        }

        public final boolean validateFirstYearIssueLicense(@Nullable Date firstDateIssueLicense, @Nullable Date lastDateIssueLicense, @Nullable Date birthDate) {
            if (firstDateIssueLicense == null) {
                return false;
            }
            int firstIssueYear = DateUtils.getYear(firstDateIssueLicense);
            if (lastDateIssueLicense != null && firstIssueYear > DateUtils.getYear(lastDateIssueLicense)) {
                return false;
            }
            boolean ageValid = true;
            if (birthDate != null) {
                int minFirstIssueYear = DateUtils.getYear(birthDate) + 18;
                ageValid = firstIssueYear >= minFirstIssueYear;
            }
            return ageValid && firstDateIssueLicense.compareTo(new Date()) <= 0;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

