/*
 * Decompiled with CFR 0.152.
 */
package ru.tochkak.logback.graylog2;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import org.graylog2.gelfclient.GelfMessage;
import org.graylog2.gelfclient.GelfMessageBuilder;
import org.graylog2.gelfclient.GelfMessageLevel;
import org.graylog2.gelfclient.transport.GelfTransport;
import ru.tochkak.logback.graylog2.AccessLogMessage;

public class GelfClientAppender
extends AppenderBase<ILoggingEvent> {
    private final GelfTransport transport;
    private final String hostname;

    GelfClientAppender(GelfTransport transport, String hostname) {
        this.transport = transport;
        this.hostname = hostname;
    }

    protected void append(ILoggingEvent eventObject) {
        this.append(this.convertToGelfMessage(eventObject));
    }

    private void append(GelfMessage gelfMessage) {
        try {
            this.transport.send(gelfMessage);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void append(String shortMessage, AccessLogMessage accessLogMessage) {
        GelfMessage gelfMessage = new GelfMessageBuilder(shortMessage, this.hostname).additionalFields(accessLogMessage.getFields()).level(GelfMessageLevel.INFO).build();
        try {
            this.transport.send(gelfMessage);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private GelfMessage convertToGelfMessage(ILoggingEvent event) {
        return new GelfMessageBuilder(event.getFormattedMessage(), this.hostname).timestamp((double)event.getTimeStamp() / 1000.0).level(this.toGelfMessageLevel(event.getLevel())).additionalField("threadname", (Object)event.getThreadName()).additionalField("logger", (Object)event.getLoggerName()).build();
    }

    private GelfMessageLevel toGelfMessageLevel(Level level) {
        switch (level.toInt()) {
            case 40000: {
                return GelfMessageLevel.ERROR;
            }
            case 30000: {
                return GelfMessageLevel.WARNING;
            }
            case 10000: {
                return GelfMessageLevel.DEBUG;
            }
        }
        return GelfMessageLevel.INFO;
    }
}

