/*
 * Decompiled with CFR 0.152.
 */
package ru.tochkak.logback.graylog2;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import com.google.common.net.HostAndPort;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.inject.Inject;
import org.graylog2.gelfclient.GelfConfiguration;
import org.graylog2.gelfclient.GelfTransports;
import org.graylog2.gelfclient.transport.GelfTransport;
import org.slf4j.LoggerFactory;
import play.Configuration;
import ru.tochkak.logback.graylog2.GelfClientAppender;
import ru.tochkak.logback.graylog2.Graylog2Component;

class Graylog2Impl
implements Graylog2Component {
    private GelfClientAppender gelfClientAppender;
    private Boolean accessLogEnabled;

    private GelfConfiguration getGelfConfiguration(Configuration config) {
        Integer queueCapacity = config.getInt("graylog2.appender.queue-size", Integer.valueOf(512));
        Long reconnectInterval = config.getMilliseconds("graylog2.appender.reconnect-interval", Long.valueOf(500L));
        Long connectTimeout = config.getMilliseconds("graylog2.appender.connect-timeout", Long.valueOf(1000L));
        Boolean isTcpNoDelay = config.getBoolean("graylog2.appender.tcp-nodelay", Boolean.valueOf(false));
        String hostString = config.getString("graylog2.appender.host", "127.0.0.1:12201");
        String protocol = config.getString("graylog2.appender.protocol", "udp");
        HostAndPort hostAndPort = HostAndPort.fromString((String)hostString);
        GelfTransports gelfTransport = GelfTransports.valueOf((String)protocol.toUpperCase());
        Integer sendBufferSize = config.getInt("graylog2.appender.sendbuffersize", Integer.valueOf(0));
        return new GelfConfiguration(hostAndPort.getHostText(), hostAndPort.getPort()).transport(gelfTransport).reconnectDelay(reconnectInterval.intValue()).queueSize(queueCapacity.intValue()).connectTimeout(connectTimeout.intValue()).tcpNoDelay(isTcpNoDelay.booleanValue()).sendBufferSize(sendBufferSize.intValue());
    }

    @Inject
    public Graylog2Impl(Configuration config) {
        String canonicalHostName;
        try {
            canonicalHostName = config.getString("graylog2.appender.sourcehost", InetAddress.getLocalHost().getCanonicalHostName());
        }
        catch (UnknownHostException e) {
            canonicalHostName = "unknown";
        }
        this.accessLogEnabled = config.getBoolean("graylog2.appender.access-log", Boolean.valueOf(false));
        GelfConfiguration gelfConfiguration = this.getGelfConfiguration(config);
        GelfTransport transport = GelfTransports.create((GelfConfiguration)gelfConfiguration);
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger rootLogger = lc.getLogger("ROOT");
        this.gelfClientAppender = new GelfClientAppender(transport, canonicalHostName);
        this.gelfClientAppender.setContext((Context)lc);
        this.gelfClientAppender.start();
        rootLogger.addAppender((Appender)this.gelfClientAppender);
    }

    @Override
    public Boolean isAccessLogEnabled() {
        return this.accessLogEnabled;
    }

    @Override
    public GelfClientAppender getGelfClientAppender() {
        return this.gelfClientAppender;
    }
}

