/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import io.dropwizard.Configuration;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import ru.vyarus.dropwizard.guice.module.installer.InstallerModule;
import ru.vyarus.dropwizard.guice.module.installer.internal.InstallerConfig;
import ru.vyarus.dropwizard.guice.module.installer.scanner.ClasspathScanner;
import ru.vyarus.dropwizard.guice.module.jersey.Jersey2Module;
import ru.vyarus.dropwizard.guice.module.support.BootstrapAwareModule;
import ru.vyarus.dropwizard.guice.module.support.ConfigurationAwareModule;
import ru.vyarus.dropwizard.guice.module.support.EnvironmentAwareModule;

public class GuiceSupportModule<T extends Configuration>
extends AbstractModule
implements BootstrapAwareModule<T>,
EnvironmentAwareModule,
ConfigurationAwareModule<T> {
    private final ClasspathScanner scanner;
    private final InstallerConfig installerConfig;
    private Bootstrap<T> bootstrap;
    private T configuration;
    private Environment environment;

    public GuiceSupportModule(ClasspathScanner scanner, InstallerConfig installerConfig) {
        this.scanner = scanner;
        this.installerConfig = installerConfig;
    }

    @Override
    public void setBootstrap(Bootstrap<T> bootstrap) {
        this.bootstrap = bootstrap;
    }

    @Override
    public void setConfiguration(T configuration) {
        this.configuration = configuration;
    }

    @Override
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    protected void configure() {
        this.bindEnvironment();
        this.install((Module)new InstallerModule(this.scanner, this.installerConfig));
        this.install((Module)new Jersey2Module(this.bootstrap.getApplication(), this.environment));
    }

    private void bindEnvironment() {
        this.bind(Bootstrap.class).toInstance(this.bootstrap);
        this.bind(Configuration.class).toInstance(this.configuration);
        Class<?> confClass = this.configuration.getClass();
        if (confClass != Configuration.class) {
            this.bind(confClass).toInstance(this.configuration);
        }
        this.bind(Environment.class).toInstance((Object)this.environment);
    }
}

