/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.bundle;

import com.google.common.base.Preconditions;
import com.google.inject.Module;
import io.dropwizard.Configuration;
import io.dropwizard.setup.Environment;
import java.util.Arrays;
import java.util.List;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.internal.InstallerConfig;

public class GuiceyBootstrap {
    private final List<Module> modules;
    private final InstallerConfig installerConfig;
    private final Configuration configuration;
    private final Environment environment;

    public GuiceyBootstrap(List<Module> modules, InstallerConfig installerConfig, Configuration configuration, Environment environment) {
        this.modules = modules;
        this.installerConfig = installerConfig;
        this.configuration = configuration;
        this.environment = environment;
    }

    public <T extends Configuration> T configuration() {
        return (T)this.configuration;
    }

    public Environment environment() {
        return this.environment;
    }

    public GuiceyBootstrap modules(Module ... modules) {
        Preconditions.checkState((modules.length > 0 ? 1 : 0) != 0, (Object)"Specify at least one module");
        this.modules.addAll(Arrays.asList(modules));
        return this;
    }

    @SafeVarargs
    public final GuiceyBootstrap disableInstallers(Class<? extends FeatureInstaller> ... installers) {
        this.installerConfig.getDisabledFeatures().addAll(Arrays.asList(installers));
        return this;
    }

    @SafeVarargs
    public final GuiceyBootstrap installers(Class<? extends FeatureInstaller> ... installers) {
        this.installerConfig.getManualFeatures().addAll(Arrays.asList(installers));
        return this;
    }

    public GuiceyBootstrap extensions(Class<?> ... extensionClasses) {
        this.installerConfig.getManualBeans().addAll(Arrays.asList(extensionClasses));
        return this;
    }
}

