/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.feature.admin;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.dropwizard.setup.Environment;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.feature.admin.AdminFilter;
import ru.vyarus.dropwizard.guice.module.installer.feature.admin.AdminServletInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.InstanceInstaller;
import ru.vyarus.dropwizard.guice.module.installer.order.Order;
import ru.vyarus.dropwizard.guice.module.installer.order.Ordered;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

@Order(value=90)
public class AdminFilterInstaller
implements FeatureInstaller<Filter>,
InstanceInstaller<Filter>,
Ordered {
    private final Reporter reporter = new Reporter(AdminServletInstaller.class, "admin filters =");

    @Override
    public boolean matches(Class<?> type) {
        return FeatureUtils.is(type, Filter.class) && FeatureUtils.hasAnnotation(type, AdminFilter.class);
    }

    @Override
    public void install(Environment environment, Filter instance) {
        Class<Filter> extType = FeatureUtils.getInstanceClass(instance);
        AdminFilter annotation = FeatureUtils.getAnnotation(extType, AdminFilter.class);
        Object[] servlets = annotation.servlets();
        String[] patterns = annotation.patterns();
        String filterName = (String)Preconditions.checkNotNull((Object)Strings.emptyToNull((String)annotation.name()), (String)"Filter name not specified for servlet %s", (Object[])new Object[]{extType.getName()});
        Preconditions.checkArgument((servlets.length > 0 || patterns.length > 0 ? 1 : 0) != 0, (String)"Filter %s not specified servlet or pattern for mapping", (Object[])new Object[]{extType.getName()});
        Preconditions.checkArgument((servlets.length == 0 || patterns.length == 0 ? 1 : 0) != 0, (String)"Filter %s specifies both servlets and patters, when only one allowed", (Object[])new Object[]{extType.getName()});
        boolean servletMapping = servlets.length > 0;
        this.reporter.line("%-10s %-10s (%s)", filterName, Joiner.on((String)",").join(servletMapping ? servlets : patterns), extType.getName());
        FilterRegistration.Dynamic mapping = environment.admin().addFilter(filterName, instance);
        if (servletMapping) {
            mapping.addMappingForServletNames(null, false, (String[])servlets);
        } else {
            mapping.addMappingForUrlPatterns(null, false, patterns);
        }
    }

    @Override
    public void report() {
        this.reporter.report();
    }
}

