/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.feature.admin;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.dropwizard.setup.Environment;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.feature.admin.AdminServlet;
import ru.vyarus.dropwizard.guice.module.installer.install.InstanceInstaller;
import ru.vyarus.dropwizard.guice.module.installer.order.Order;
import ru.vyarus.dropwizard.guice.module.installer.order.Ordered;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

@Order(value=100)
public class AdminServletInstaller
implements FeatureInstaller<HttpServlet>,
InstanceInstaller<HttpServlet>,
Ordered {
    private final Reporter reporter = new Reporter(AdminServletInstaller.class, "admin servlets =");

    @Override
    public boolean matches(Class<?> type) {
        return FeatureUtils.is(type, HttpServlet.class) && FeatureUtils.hasAnnotation(type, AdminServlet.class);
    }

    @Override
    public void install(Environment environment, HttpServlet instance) {
        Class<HttpServlet> extType = FeatureUtils.getInstanceClass(instance);
        AdminServlet annotation = FeatureUtils.getAnnotation(extType, AdminServlet.class);
        String servletName = (String)Preconditions.checkNotNull((Object)Strings.emptyToNull((String)annotation.name()), (String)"Servlet name not specified for servlet %s", (Object[])new Object[]{extType.getName()});
        Object[] patterns = annotation.patterns();
        this.reporter.line("%-10s %-10s (%s)", servletName, Joiner.on((String)",").join(patterns), extType.getName());
        environment.admin().addServlet(servletName, (Servlet)instance).addMapping((String[])patterns);
    }

    @Override
    public void report() {
        this.reporter.report();
    }
}

