/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.internal;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import io.dropwizard.setup.Bootstrap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class DwBundleSupport {
    private DwBundleSupport() {
    }

    public static <T> List<T> findBundles(Bootstrap bootstrap, Class<T> type) {
        ArrayList bundles = Lists.newArrayList(DwBundleSupport.resolveBundles(bootstrap, "bundles"));
        bundles.addAll(DwBundleSupport.resolveBundles(bootstrap, "configuredBundles"));
        Iterator it = bundles.iterator();
        while (it.hasNext()) {
            if (type.isAssignableFrom(it.next().getClass())) continue;
            it.remove();
        }
        return bundles;
    }

    private static <T> List<T> resolveBundles(Bootstrap bootstrap, String field) {
        try {
            Field declaredField = Bootstrap.class.getDeclaredField(field);
            declaredField.setAccessible(true);
            List res = (List)declaredField.get(bootstrap);
            declaredField.setAccessible(false);
            return (List)MoreObjects.firstNonNull((Object)res, Collections.emptyList());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to resolve bootstrap filed " + field, e);
        }
    }
}

