/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.order.OrderComparator;
import ru.vyarus.dropwizard.guice.module.installer.order.Ordered;

public class FeaturesHolder {
    private final List<FeatureInstaller> installers;
    private final List<Class<? extends FeatureInstaller>> installerTypes;
    private final Map<Class<? extends FeatureInstaller>, List<Class<?>>> features = Maps.newHashMap();

    public FeaturesHolder(List<FeatureInstaller> installers) {
        this.installers = installers;
        this.installerTypes = Lists.transform(installers, (Function)new Function<FeatureInstaller, Class<? extends FeatureInstaller>>(){

            public Class<? extends FeatureInstaller> apply(FeatureInstaller input) {
                return input.getClass();
            }
        });
    }

    public void register(Class<? extends FeatureInstaller> installer, Class feature) {
        Preconditions.checkArgument((boolean)this.installerTypes.contains(installer), (String)"Installer %s not registered", (Object[])new Object[]{installer.getSimpleName()});
        if (!this.features.containsKey(installer)) {
            this.features.put(installer, Lists.newArrayList());
        }
        this.features.get(installer).add(feature);
    }

    public List<FeatureInstaller> getInstallers() {
        return this.installers;
    }

    public List<Class<?>> getFeatures(Class<? extends FeatureInstaller> installer) {
        return this.features.get(installer);
    }

    public void order() {
        OrderComparator comparator = new OrderComparator();
        for (Class<? extends FeatureInstaller> installer : this.installerTypes) {
            List<Class<?>> extensions;
            if (!Ordered.class.isAssignableFrom(installer) || (extensions = this.features.get(installer)) == null || extensions.size() <= 1) continue;
            Collections.sort(extensions, comparator);
        }
    }
}

