/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.util;

import com.google.inject.Injector;
import io.dropwizard.Application;
import io.dropwizard.cli.Command;
import io.dropwizard.cli.EnvironmentCommand;
import io.dropwizard.setup.Bootstrap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.scanner.ClassVisitor;
import ru.vyarus.dropwizard.guice.module.installer.scanner.ClasspathScanner;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;

public final class CommandSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandSupport.class);

    private CommandSupport() {
    }

    public static void registerCommands(Bootstrap bootstrap, ClasspathScanner scanner) {
        scanner.scan(new CommandClassVisitor(bootstrap));
    }

    public static void initCommands(List<Command> commands, Injector injector) {
        if (commands != null) {
            for (Command cmd : commands) {
                if (!(cmd instanceof EnvironmentCommand)) continue;
                injector.injectMembers((Object)cmd);
            }
        }
    }

    private static class CommandClassVisitor
    implements ClassVisitor {
        private final Bootstrap bootstrap;

        CommandClassVisitor(Bootstrap bootstrap) {
            this.bootstrap = bootstrap;
        }

        @Override
        public void visit(Class<?> type) {
            if (FeatureUtils.is(type, Command.class)) {
                try {
                    Command cmd = EnvironmentCommand.class.isAssignableFrom(type) ? (Command)type.getConstructor(Application.class).newInstance(this.bootstrap.getApplication()) : (Command)type.newInstance();
                    this.bootstrap.addCommand(cmd);
                    LOGGER.debug("Command registered: {}", (Object)type.getSimpleName());
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to instantiate command: " + type.getSimpleName(), e);
                }
            }
        }
    }
}

