/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.jersey;

import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.ServletModule;
import io.dropwizard.Application;
import io.dropwizard.setup.Environment;
import javax.inject.Provider;
import javax.servlet.Filter;
import org.glassfish.hk2.api.ServiceLocator;
import ru.vyarus.dropwizard.guice.injector.lookup.InjectorProvider;
import ru.vyarus.dropwizard.guice.module.installer.internal.AdminGuiceFilter;
import ru.vyarus.dropwizard.guice.module.jersey.GuiceFeature;
import ru.vyarus.dropwizard.guice.module.jersey.hk2.GuiceBindingsModule;

public class Jersey2Module
extends ServletModule {
    public static final String GUICE_FILTER = "Guice Filter";
    private static final String STAR = "*";
    private final Application application;
    private final Environment environment;

    public Jersey2Module(Application application, Environment environment) {
        this.application = application;
        this.environment = environment;
    }

    protected void configureServlets() {
        InjectorProvider provider = new InjectorProvider(this.application);
        this.install((Module)new GuiceBindingsModule(provider));
        GuiceFeature component = new GuiceFeature(provider);
        this.bind(ServiceLocator.class).toProvider((Provider)component);
        this.environment.jersey().register((Object)component);
        GuiceFilter guiceFilter = new GuiceFilter();
        this.environment.servlets().addFilter(GUICE_FILTER, (Filter)guiceFilter).addMappingForUrlPatterns(null, false, new String[]{this.environment.getApplicationContext().getContextPath() + STAR});
        this.environment.admin().addFilter(GUICE_FILTER, (Filter)new AdminGuiceFilter(guiceFilter)).addMappingForUrlPatterns(null, false, new String[]{this.environment.getAdminContext().getContextPath() + STAR});
    }
}

