/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.spock.ext;

import com.google.inject.Injector;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.InjectionPoint;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.junit.rules.ExternalResource;
import org.spockframework.runtime.extension.AbstractMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.SpecInfo;
import ru.vyarus.dropwizard.guice.test.spock.ext.GuiceyExtensionException;
import spock.lang.Shared;

public class GuiceyInterceptor
extends AbstractMethodInterceptor {
    private static Method before;
    private static Method after;
    private final ExternalRuleAdapter externalRuleAdapter;
    private final Set<InjectionPoint> injectionPoints;
    private ExternalResource resource;

    public GuiceyInterceptor(SpecInfo spec, ExternalRuleAdapter externalRuleAdapter) {
        this.externalRuleAdapter = externalRuleAdapter;
        this.injectionPoints = InjectionPoint.forInstanceMethodsAndFields((Class)((Class)spec.getReflection()));
    }

    public void interceptSharedInitializerMethod(IMethodInvocation invocation) throws Throwable {
        if (this.resource == null) {
            this.resource = this.externalRuleAdapter.newResource();
        }
        before.invoke((Object)this.resource, new Object[0]);
        this.injectValues(invocation.getSharedInstance(), true);
        invocation.proceed();
    }

    public void interceptInitializerMethod(IMethodInvocation invocation) throws Throwable {
        this.injectValues(invocation.getInstance(), false);
        invocation.proceed();
    }

    public void interceptCleanupSpecMethod(IMethodInvocation invocation) throws Throwable {
        try {
            invocation.proceed();
        }
        finally {
            after.invoke((Object)this.resource, new Object[0]);
        }
    }

    private void injectValues(Object target, boolean sharedFields) throws IllegalAccessException {
        for (InjectionPoint point : this.injectionPoints) {
            if (!(point.getMember() instanceof Field)) {
                throw new GuiceyExtensionException("Method injection is not supported; use field injection instead");
            }
            Field field = (Field)point.getMember();
            if (field.isAnnotationPresent(Shared.class) != sharedFields) continue;
            Object value = this.externalRuleAdapter.getInjector().getInstance(((Dependency)point.getDependencies().get(0)).getKey());
            field.setAccessible(true);
            field.set(target, value);
        }
    }

    static {
        try {
            before = ExternalResource.class.getDeclaredMethod("before", new Class[0]);
            before.setAccessible(true);
            after = ExternalResource.class.getDeclaredMethod("after", new Class[0]);
            after.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new GuiceyExtensionException("Failed resolve method", e);
        }
    }

    public static interface ExternalRuleAdapter {
        public ExternalResource newResource();

        public Injector getInjector();
    }
}

