package ru.vyarus.dropwizard.guice.admin.rest;

import javax.ws.rs.NameBinding;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Security annotation to deny access to admin specific rest from user context.
 * Annotation may be used on resource class to hide all resource methods or directly
 * on methods (for hybrid cases).
 * <p>When secured resource is accessed from user context, 403 error will be returned.</p>
 * <p>Requires {@link ru.vyarus.dropwizard.guice.admin.AdminRestBundle} to be registered, otherwise will not
 * have any effect.</p>
 *
 * @author Vyacheslav Rusakov
 * @since 04.08.2015
 */
@NameBinding
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD})
public @interface AdminResource {
}
