/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.cli.Command;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import ru.vyarus.dropwizard.guice.bundle.DefaultBundleLookup;
import ru.vyarus.dropwizard.guice.bundle.GuiceyBundleLookup;
import ru.vyarus.dropwizard.guice.bundle.lookup.VoidBundleLookup;
import ru.vyarus.dropwizard.guice.injector.DefaultInjectorFactory;
import ru.vyarus.dropwizard.guice.injector.InjectorFactory;
import ru.vyarus.dropwizard.guice.injector.lookup.InjectorLookup;
import ru.vyarus.dropwizard.guice.module.GuiceSupportModule;
import ru.vyarus.dropwizard.guice.module.installer.CoreInstallersBundle;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBootstrap;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.dropwizard.guice.module.installer.internal.CommandSupport;
import ru.vyarus.dropwizard.guice.module.installer.internal.InstallerConfig;
import ru.vyarus.dropwizard.guice.module.installer.scanner.ClasspathScanner;
import ru.vyarus.dropwizard.guice.module.installer.util.BundleSupport;
import ru.vyarus.dropwizard.guice.module.support.BootstrapAwareModule;
import ru.vyarus.dropwizard.guice.module.support.ConfigurationAwareModule;
import ru.vyarus.dropwizard.guice.module.support.EnvironmentAwareModule;

public final class GuiceBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private Injector injector;
    private final List<Module> modules = Lists.newArrayList();
    private final List<GuiceyBundle> bundles = Lists.newArrayList();
    private final Set<String> autoscanPackages = Sets.newHashSet();
    private final InstallerConfig installerConfig = new InstallerConfig();
    private InjectorFactory injectorFactory = new DefaultInjectorFactory();
    private GuiceyBundleLookup bundleLookup = new DefaultBundleLookup();
    private boolean searchCommands;
    private boolean configureFromDropwizardBundles;
    private Stage stage = Stage.PRODUCTION;
    private Bootstrap bootstrap;
    private ClasspathScanner scanner;

    GuiceBundle() {
    }

    public void initialize(Bootstrap bootstrap) {
        if (this.searchCommands) {
            Preconditions.checkState((!this.autoscanPackages.isEmpty() ? 1 : 0) != 0, (Object)"Commands search could not be performed, because auto scan was not activated");
        }
        this.bootstrap = bootstrap;
        if (!this.autoscanPackages.isEmpty()) {
            this.scanner = new ClasspathScanner(this.autoscanPackages);
            if (this.searchCommands) {
                CommandSupport.registerCommands(bootstrap, this.scanner);
            }
        }
    }

    public void run(T configuration, Environment environment) throws Exception {
        this.configureFromBundles(configuration, environment);
        this.modules.add((Module)new GuiceSupportModule(this.scanner, this.installerConfig));
        this.configureModules(configuration, environment);
        this.injector = this.injectorFactory.createInjector(this.stage, this.modules);
        environment.lifecycle().manage(InjectorLookup.registerInjector(this.bootstrap.getApplication(), this.injector));
        CommandSupport.initCommands((List<Command>)this.bootstrap.getCommands(), this.injector);
    }

    public Injector getInjector() {
        return (Injector)Preconditions.checkNotNull((Object)this.injector, (Object)"Guice not initialized");
    }

    private void configureFromBundles(T configuration, Environment environment) {
        GuiceyBootstrap guiceyBootstrap = new GuiceyBootstrap(this.modules, this.installerConfig, (Configuration)configuration, environment);
        if (this.configureFromDropwizardBundles) {
            this.bundles.addAll(BundleSupport.findBundles(this.bootstrap, GuiceyBundle.class));
        }
        this.bundles.addAll(this.bundleLookup.lookup());
        for (GuiceyBundle bundle : BundleSupport.removeDuplicates(this.bundles)) {
            bundle.initialize(guiceyBootstrap);
        }
    }

    private void configureModules(T configuration, Environment environment) {
        for (Module mod : this.modules) {
            if (mod instanceof BootstrapAwareModule) {
                ((BootstrapAwareModule)mod).setBootstrap(this.bootstrap);
            }
            if (mod instanceof ConfigurationAwareModule) {
                ((ConfigurationAwareModule)mod).setConfiguration(configuration);
            }
            if (!(mod instanceof EnvironmentAwareModule)) continue;
            ((EnvironmentAwareModule)mod).setEnvironment(environment);
        }
    }

    public static <T extends Configuration> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T extends Configuration> {
        private final GuiceBundle<T> bundle = new GuiceBundle();

        public Builder<T> injectorFactory(InjectorFactory injectorFactory) {
            ((GuiceBundle)this.bundle).injectorFactory = injectorFactory;
            return this;
        }

        public Builder<T> bundleLookup(GuiceyBundleLookup bundleLookup) {
            ((GuiceBundle)this.bundle).bundleLookup = bundleLookup;
            return this;
        }

        public Builder<T> disableBundleLookup() {
            return this.bundleLookup(new VoidBundleLookup());
        }

        public Builder<T> enableAutoConfig(String ... basePackages) {
            Preconditions.checkState((boolean)((GuiceBundle)this.bundle).autoscanPackages.isEmpty(), (Object)"Auto config packages already configured");
            Preconditions.checkState((basePackages.length > 0 ? 1 : 0) != 0, (Object)"Specify at least one package to scan");
            ((GuiceBundle)this.bundle).autoscanPackages.addAll(Arrays.asList(basePackages));
            ((GuiceBundle)this.bundle).bundles.add(new CoreInstallersBundle());
            return this;
        }

        public Builder<T> modules(Module ... modules) {
            Preconditions.checkState((modules.length > 0 ? 1 : 0) != 0, (Object)"Specify at least one module");
            ((GuiceBundle)this.bundle).modules.addAll(Arrays.asList(modules));
            return this;
        }

        public Builder<T> searchCommands(boolean searchCommands) {
            ((GuiceBundle)this.bundle).searchCommands = searchCommands;
            return this;
        }

        @SafeVarargs
        public final Builder<T> disableInstallers(Class<? extends FeatureInstaller> ... installers) {
            ((GuiceBundle)this.bundle).installerConfig.getDisabledFeatures().addAll(Arrays.asList(installers));
            return this;
        }

        @SafeVarargs
        public final Builder<T> installers(Class<? extends FeatureInstaller> ... installers) {
            ((GuiceBundle)this.bundle).installerConfig.getManualFeatures().addAll(Arrays.asList(installers));
            return this;
        }

        public Builder<T> extensions(Class<?> ... extensionClasses) {
            ((GuiceBundle)this.bundle).installerConfig.getManualBeans().addAll(Arrays.asList(extensionClasses));
            return this;
        }

        public Builder<T> bundles(GuiceyBundle ... bundles) {
            ((GuiceBundle)this.bundle).bundles.addAll(Arrays.asList(bundles));
            return this;
        }

        public Builder<T> configureFromDropwizardBundles(boolean enable) {
            ((GuiceBundle)this.bundle).configureFromDropwizardBundles = enable;
            return this;
        }

        public GuiceBundle<T> build(Stage stage) {
            ((GuiceBundle)this.bundle).stage = stage;
            return this.bundle;
        }

        public GuiceBundle<T> build() {
            return this.build(Stage.PRODUCTION);
        }
    }
}

