/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.bundle;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import ru.vyarus.dropwizard.guice.bundle.GuiceyBundleLookup;
import ru.vyarus.dropwizard.guice.bundle.lookup.PropertyBundleLookup;
import ru.vyarus.dropwizard.guice.bundle.lookup.ServiceLoaderBundleLookup;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;

public class DefaultBundleLookup
implements GuiceyBundleLookup {
    private static final Marker MARKER = MarkerFactory.getMarker((String)"bundle reporter");
    private final Logger logger = LoggerFactory.getLogger(DefaultBundleLookup.class);
    private final List<GuiceyBundleLookup> lookups = Lists.newArrayList();

    public DefaultBundleLookup() {
        this(new PropertyBundleLookup(), new ServiceLoaderBundleLookup());
    }

    public DefaultBundleLookup(GuiceyBundleLookup ... lookups) {
        for (GuiceyBundleLookup lookup : lookups) {
            this.addLookup(lookup);
        }
    }

    @Override
    public List<GuiceyBundle> lookup() {
        ArrayList res = Lists.newArrayList();
        for (GuiceyBundleLookup lookup : this.lookups) {
            res.addAll(lookup.lookup());
        }
        this.report(res);
        return res;
    }

    public DefaultBundleLookup addLookup(GuiceyBundleLookup lookup) {
        this.lookups.add(lookup);
        return this;
    }

    private void report(List<GuiceyBundle> bundles) {
        if (bundles.isEmpty()) {
            return;
        }
        StringBuilder msg = new StringBuilder("guicey bundles lookup =\n\n");
        for (GuiceyBundle bundle : bundles) {
            msg.append('\t').append(bundle.getClass().getName());
        }
        msg.append('\n');
        this.logger.info(MARKER, msg.toString());
    }
}

