/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.binding.BindingInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.binding.LazyBinding;
import ru.vyarus.dropwizard.guice.module.installer.internal.FeatureInstallerExecutor;
import ru.vyarus.dropwizard.guice.module.installer.internal.FeaturesHolder;
import ru.vyarus.dropwizard.guice.module.installer.internal.InstallerConfig;
import ru.vyarus.dropwizard.guice.module.installer.order.OrderComparator;
import ru.vyarus.dropwizard.guice.module.installer.scanner.ClassVisitor;
import ru.vyarus.dropwizard.guice.module.installer.scanner.ClasspathScanner;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;

public class InstallerModule
extends AbstractModule {
    private static final OrderComparator COMPARATOR = new OrderComparator();
    private final Logger logger = LoggerFactory.getLogger(InstallerModule.class);
    private final ClasspathScanner scanner;
    private final InstallerConfig installerConfig;

    public InstallerModule(ClasspathScanner scanner, InstallerConfig installerConfig) {
        this.scanner = scanner;
        this.installerConfig = installerConfig;
    }

    protected void configure() {
        this.bind(FeatureInstallerExecutor.class).asEagerSingleton();
        List<Class<? extends FeatureInstaller>> installerClasses = this.findInstallers();
        List<FeatureInstaller> installers = this.prepareInstallers(installerClasses);
        FeaturesHolder holder = new FeaturesHolder(installers);
        this.bind(FeaturesHolder.class).toInstance((Object)holder);
        this.resolveFeatures(holder);
    }

    private List<Class<? extends FeatureInstaller>> findInstallers() {
        final ArrayList installers = Lists.newArrayList();
        if (this.scanner != null) {
            this.scanner.scan(new ClassVisitor(){

                @Override
                public void visit(Class<?> type) {
                    if (FeatureUtils.is(type, FeatureInstaller.class)) {
                        installers.add(type);
                    }
                }
            });
        }
        installers.addAll(this.installerConfig.getManualFeatures());
        HashSet validInstallers = Sets.newHashSet((Iterable)Iterables.filter((Iterable)installers, (Predicate)new Predicate<Class<? extends FeatureInstaller>>(){

            public boolean apply(@Nullable Class<? extends FeatureInstaller> input) {
                return !InstallerModule.this.installerConfig.getDisabledFeatures().contains(input);
            }
        }));
        installers.clear();
        installers.addAll(validInstallers);
        Collections.sort(installers, COMPARATOR);
        this.logger.debug("Found {} feature installers", (Object)installers.size());
        return installers;
    }

    private List<FeatureInstaller> prepareInstallers(List<Class<? extends FeatureInstaller>> installerClasses) {
        ArrayList installers = Lists.newArrayList();
        for (Class<? extends FeatureInstaller> installerClass : installerClasses) {
            try {
                FeatureInstaller installer = installerClass.newInstance();
                installers.add(installer);
                this.logger.trace("Registered feature installer: {}", (Object)FeatureUtils.getInstallerExtName(installerClass));
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to register installer " + installerClass.getName(), e);
            }
        }
        return installers;
    }

    private void resolveFeatures(final FeaturesHolder holder) {
        if (this.scanner != null) {
            this.scanner.scan(new ClassVisitor(){

                @Override
                public void visit(Class<?> type) {
                    InstallerModule.this.processType(type, holder);
                }
            });
        }
        for (Class<?> type : this.installerConfig.getManualBeans()) {
            Preconditions.checkState((boolean)this.processType(type, holder), (String)"No installer found for type %s", (Object[])new Object[]{type.getName()});
        }
    }

    private boolean processType(Class<?> type, FeaturesHolder holder) {
        boolean recognized = false;
        for (FeatureInstaller installer : holder.getInstallers()) {
            if (!installer.matches(type)) continue;
            recognized = true;
            this.logger.trace("{} extension found: {}", (Object)FeatureUtils.getInstallerExtName(installer.getClass()), (Object)type.getName());
            holder.register(installer.getClass(), type);
            boolean lazy = type.isAnnotationPresent(LazyBinding.class);
            if (installer instanceof BindingInstaller) {
                ((BindingInstaller)((Object)installer)).install(this.binder(), type, lazy);
                continue;
            }
            if (lazy) continue;
            this.binder().bind(type);
        }
        return recognized;
    }
}

