/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.feature.jersey.provider;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.Injector;
import java.util.Set;
import javax.inject.Singleton;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.feature.jersey.provider.ProviderReporter;
import ru.vyarus.dropwizard.guice.module.installer.install.JerseyInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.binding.BindingInstaller;
import ru.vyarus.dropwizard.guice.module.installer.order.Order;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.JerseyBinding;
import ru.vyarus.java.generics.resolver.GenericsResolver;

@Order(value=30)
public class JerseyProviderInstaller
implements FeatureInstaller<Object>,
BindingInstaller,
JerseyInstaller<Object> {
    private static final Set<Class<?>> EXTENSION_TYPES = ImmutableSet.of(ExceptionMapper.class, ParamConverterProvider.class, ContextResolver.class, MessageBodyReader.class, MessageBodyWriter.class, ReaderInterceptor.class, (Object[])new Class[]{WriterInterceptor.class, ContainerRequestFilter.class, ContainerResponseFilter.class, DynamicFeature.class, ValueFactoryProvider.class, InjectionResolver.class, ApplicationEventListener.class});
    private final Logger logger = LoggerFactory.getLogger(JerseyProviderInstaller.class);
    private final ProviderReporter reporter = new ProviderReporter();

    @Override
    public boolean matches(Class<?> type) {
        return FeatureUtils.hasAnnotation(type, Provider.class);
    }

    @Override
    public <T> void install(Binder binder, Class<? extends T> type, boolean lazy) {
        boolean isHkManaged = JerseyBinding.isHK2Managed(type);
        if (isHkManaged && lazy) {
            this.logger.warn("@LazyBinding is ignored, because @HK2Managed set: {}", (Object)type.getName());
        }
        if (!isHkManaged && !lazy) {
            binder.bind(type).in(Singleton.class);
        }
        this.reporter.provider(type, isHkManaged, lazy);
    }

    @Override
    public void install(AbstractBinder binder, Injector injector, Class<Object> type) {
        if (FeatureUtils.is(type, Factory.class)) {
            JerseyBinding.bindFactory(binder, injector, type);
        } else {
            Sets.SetView extensions = Sets.intersection(EXTENSION_TYPES, (Set)GenericsResolver.resolve(type, (Class[])new Class[0]).getGenericsInfo().getComposingTypes());
            if (!extensions.isEmpty()) {
                for (Class ext : extensions) {
                    JerseyBinding.bindSpecificComponent(binder, injector, type, ext);
                }
            } else {
                JerseyBinding.bindComponent(binder, injector, type);
            }
        }
    }

    @Override
    public void report() {
        this.reporter.report();
    }
}

