/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.internal;

import com.google.inject.Inject;
import com.google.inject.Injector;
import io.dropwizard.setup.Environment;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.InstanceInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.JerseyInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.TypeInstaller;
import ru.vyarus.dropwizard.guice.module.installer.internal.FeaturesHolder;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;

public class FeatureInstallerExecutor {
    private final Logger logger = LoggerFactory.getLogger(FeatureInstallerExecutor.class);
    private final FeaturesHolder holder;
    private final Environment environment;
    private final Injector injector;

    @Inject
    public FeatureInstallerExecutor(FeaturesHolder holder, Environment environment, Injector injector) {
        this.holder = holder;
        this.environment = environment;
        this.injector = injector;
        this.installFeatures();
    }

    private void installFeatures() {
        this.holder.order();
        for (FeatureInstaller installer : this.holder.getInstallers()) {
            List<Class<?>> res = this.holder.getFeatures(installer.getClass());
            if (res != null) {
                for (Class<?> inst : res) {
                    if (installer instanceof TypeInstaller) {
                        ((TypeInstaller)((Object)installer)).install(this.environment, inst);
                    }
                    if (installer instanceof InstanceInstaller) {
                        ((InstanceInstaller)((Object)installer)).install(this.environment, this.injector.getInstance(inst));
                    }
                    this.logger.trace("{} extension installed: {}", (Object)FeatureUtils.getInstallerExtName(installer.getClass()), (Object)inst.getName());
                }
            }
            if (installer instanceof JerseyInstaller) continue;
            installer.report();
        }
    }
}

