/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.scanner;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import ru.vyarus.dropwizard.guice.module.installer.scanner.ClassVisitor;
import ru.vyarus.dropwizard.guice.module.installer.scanner.InvisibleForScanner;
import ru.vyarus.dropwizard.guice.module.installer.scanner.util.OReflectionHelper;

public class ClasspathScanner {
    private final Set<String> packages;

    public ClasspathScanner(Set<String> packages) {
        this.packages = this.validate(packages);
    }

    public void scan(ClassVisitor visitor) {
        for (String pkg : this.packages) {
            List<Class<?>> found;
            try {
                found = OReflectionHelper.getClassesFor(pkg, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Failed to scan classpath", e);
            }
            for (Class<?> cls : found) {
                if (cls.isAnnotationPresent(InvisibleForScanner.class)) continue;
                visitor.visit(cls);
            }
        }
    }

    private Set<String> validate(Set<String> packages) {
        ArrayList pkg = Lists.newArrayList(packages);
        Collections.sort(pkg, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Integer.compare(o1.length(), o2.length());
            }
        });
        for (int i = 0; i < pkg.size(); ++i) {
            String path = (String)pkg.get(i);
            for (int j = i + 1; j < pkg.size(); ++j) {
                String path2 = (String)pkg.get(j);
                Preconditions.checkState((!path2.startsWith(path + ".") ? 1 : 0) != 0, (String)"Autoscan path '%s' is already covered by '%s' and may lead to duplicate instances in runtime", (Object[])new Object[]{path2, path});
            }
        }
        return packages;
    }
}

