/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.util;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.binder.ScopedBindingBuilder;
import java.lang.reflect.Type;
import java.util.List;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.hk2.utilities.reflection.ParameterizedTypeImpl;
import ru.vyarus.dropwizard.guice.module.installer.feature.jersey.HK2Managed;
import ru.vyarus.dropwizard.guice.module.jersey.support.GuiceComponentFactory;
import ru.vyarus.dropwizard.guice.module.jersey.support.JerseyComponentProvider;
import ru.vyarus.dropwizard.guice.module.jersey.support.LazyGuiceFactory;
import ru.vyarus.java.generics.resolver.GenericsResolver;
import ru.vyarus.java.generics.resolver.context.TypeGenericsContext;

public final class JerseyBinding {
    private JerseyBinding() {
    }

    public static boolean isHK2Managed(Class<?> type) {
        return type.isAnnotationPresent(HK2Managed.class);
    }

    public static void bindComponent(AbstractBinder binder, Injector injector, Class<?> type) {
        if (JerseyBinding.isHK2Managed(type)) {
            binder.bindAsContract(type).in(Singleton.class);
        } else {
            binder.bindFactory(new GuiceComponentFactory(injector, type)).to(type);
        }
    }

    public static <T> void bindFactory(AbstractBinder binder, Injector injector, Class<?> type) {
        Class res = GenericsResolver.resolve(type, (Class[])new Class[0]).type(Factory.class).generic(0);
        if (JerseyBinding.isHK2Managed(type)) {
            binder.bindFactory(type).to(res).in(Singleton.class);
        } else {
            binder.bindFactory(new LazyGuiceFactory(injector, type)).to(res);
            binder.bindFactory(new GuiceComponentFactory(injector, type)).to(type);
        }
    }

    public static void bindSpecificComponent(AbstractBinder binder, Injector injector, Class<?> type, Class<?> specificType) {
        ParameterizedTypeImpl binding;
        TypeGenericsContext context = GenericsResolver.resolve(type, (Class[])new Class[0]).type(specificType);
        List genericTypes = context.genericTypes();
        Type[] generics = genericTypes.toArray(new Type[genericTypes.size()]);
        ParameterizedTypeImpl parameterizedTypeImpl = binding = generics.length > 0 ? new ParameterizedTypeImpl((Type)specificType, generics) : specificType;
        if (JerseyBinding.isHK2Managed(type)) {
            binder.bind(type).to((Type)binding).in(Singleton.class);
        } else if (InjectionResolver.class.equals((Object)specificType)) {
            binder.bindFactory(new GuiceComponentFactory(injector, type)).to(type).in(Singleton.class);
            binder.bind(type).to((Type)binding).in(Singleton.class);
        } else {
            binder.bindFactory(new GuiceComponentFactory(injector, type)).to(type).to((Type)binding).in(Singleton.class);
        }
    }

    public static <T> ScopedBindingBuilder bindJerseyComponent(Binder binder, Provider<Injector> provider, Class<T> type) {
        return binder.bind(type).toProvider(new JerseyComponentProvider<T>(provider, type));
    }
}

