/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;

public class Reporter {
    protected static final String NEWLINE = String.format("%n", new Object[0]);
    protected static final String TAB = "    ";
    protected static final String LAZY_MARKER = " *LAZY_MARKER";
    private static final Marker MARKER = MarkerFactory.getMarker((String)"installer reporter");
    private Logger logger;
    private StringBuilder message = new StringBuilder();
    private int counter;
    private boolean wasEmptyLine;

    public Reporter(Class<? extends FeatureInstaller> type, String title) {
        this.logger = LoggerFactory.getLogger(type);
        this.message.append(title).append(NEWLINE);
        this.emptyLine();
    }

    public final String lazy(boolean isLazy) {
        return isLazy ? LAZY_MARKER : "";
    }

    public final Reporter line(String line, Object ... args) {
        ++this.counter;
        this.wasEmptyLine = false;
        this.message.append(TAB).append(String.format(line, args)).append(NEWLINE);
        return this;
    }

    public final Reporter emptyLine() {
        this.wasEmptyLine = true;
        this.message.append(NEWLINE);
        return this;
    }

    public final Reporter separate() {
        if (this.message.length() > 0 && !this.wasEmptyLine) {
            this.emptyLine();
        }
        return this;
    }

    public void report() {
        if (this.counter > 0) {
            this.logger.info(MARKER, this.message.toString());
        }
        this.message = null;
        this.logger = null;
    }
}

