/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.jersey;

import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import java.lang.annotation.Annotation;
import javax.inject.Provider;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.ServiceLocatorProvider;
import org.jvnet.hk2.guice.bridge.api.GuiceBridge;
import org.jvnet.hk2.guice.bridge.api.GuiceIntoHK2Bridge;
import ru.vyarus.dropwizard.guice.module.jersey.hk2.InstallerBinder;

public class GuiceFeature
implements Feature,
Provider<ServiceLocator> {
    private final Provider<Injector> provider;
    private ServiceLocator locator;

    public GuiceFeature(Provider<Injector> provider) {
        this.provider = provider;
    }

    public boolean configure(FeatureContext context) {
        this.locator = ServiceLocatorProvider.getServiceLocator((FeatureContext)context);
        Injector injector = (Injector)this.provider.get();
        GuiceBridge.getGuiceBridge().initializeGuiceBridge(this.locator);
        GuiceIntoHK2Bridge guiceBridge = (GuiceIntoHK2Bridge)this.locator.getService(GuiceIntoHK2Bridge.class, new Annotation[0]);
        guiceBridge.bridgeGuiceInjector(injector);
        context.register((Object)new InstallerBinder(injector));
        return true;
    }

    public ServiceLocator get() {
        return (ServiceLocator)Preconditions.checkNotNull((Object)this.locator, (Object)"Service locator is not yet available");
    }
}

