/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.jersey.debug.service;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DescriptorType;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.InstanceLifecycleEvent;
import org.glassfish.hk2.api.InstanceLifecycleEventType;
import org.glassfish.hk2.api.InstanceLifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.jersey.debug.service.ContextDebugService;

@Singleton
public class HK2InstanceListener
implements InstanceLifecycleListener {
    private final Logger logger = LoggerFactory.getLogger(HK2InstanceListener.class);
    private final ContextDebugService contextDebugService;

    @Inject
    public HK2InstanceListener(ContextDebugService contextDebugService) {
        this.contextDebugService = contextDebugService;
    }

    public Filter getFilter() {
        final List managedTypes = Lists.transform(this.contextDebugService.getManagedTypes(), (Function)new Function<Class<?>, String>(){

            public String apply(@Nonnull Class<?> input) {
                return input.getName();
            }
        });
        return new Filter(){

            public boolean matches(Descriptor d) {
                return d.getDescriptorType() == DescriptorType.CLASS && managedTypes.contains(d.getImplementation());
            }
        };
    }

    public void lifecycleEvent(InstanceLifecycleEvent event) {
        Class implClass = event.getActiveDescriptor().getImplementationClass();
        if (event.getEventType() == InstanceLifecycleEventType.PRE_PRODUCTION) {
            this.logger.info("HK2 creates service: {}", (Object)implClass.getName());
            this.contextDebugService.hkManage(implClass);
        }
    }
}

