/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.jersey.hk2;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.servlet.RequestScoped;
import javax.inject.Provider;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.process.AsyncContext;
import ru.vyarus.dropwizard.guice.module.installer.util.JerseyBinding;

public class GuiceBindingsModule
extends AbstractModule {
    private final Provider<Injector> provider;

    public GuiceBindingsModule(Provider<Injector> provider) {
        this.provider = provider;
    }

    protected void configure() {
        this.jerseyToGuice(MultivaluedParameterExtractorProvider.class);
        this.jerseyToGuice(Application.class);
        this.jerseyToGuice(Providers.class);
        this.jerseyToGuice(UriInfo.class).in(RequestScoped.class);
        this.jerseyToGuice(HttpHeaders.class).in(RequestScoped.class);
        this.jerseyToGuice(SecurityContext.class).in(RequestScoped.class);
        this.jerseyToGuice(Request.class).in(RequestScoped.class);
        this.jerseyToGuice(ContainerRequest.class).in(RequestScoped.class);
        this.jerseyToGuice(AsyncContext.class).in(RequestScoped.class);
    }

    private ScopedBindingBuilder jerseyToGuice(Class<?> type) {
        return JerseyBinding.bindJerseyComponent(this.binder(), this.provider, type);
    }
}

