/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.Module;
import io.dropwizard.Configuration;
import io.dropwizard.cli.Command;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import ru.vyarus.dropwizard.guice.GuiceBundle;
import ru.vyarus.dropwizard.guice.GuiceyOptions;
import ru.vyarus.dropwizard.guice.hook.ConfigurationHooksSupport;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.ConfigScope;
import ru.vyarus.dropwizard.guice.module.context.info.ItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.ModuleItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.impl.ExtensionItemInfoImpl;
import ru.vyarus.dropwizard.guice.module.context.info.impl.ItemInfoImpl;
import ru.vyarus.dropwizard.guice.module.context.info.impl.ModuleItemInfoImpl;
import ru.vyarus.dropwizard.guice.module.context.info.sign.DisableSupport;
import ru.vyarus.dropwizard.guice.module.context.option.Options;
import ru.vyarus.dropwizard.guice.module.context.option.internal.OptionsSupport;
import ru.vyarus.dropwizard.guice.module.context.stat.StatsTracker;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.dropwizard.guice.module.lifecycle.internal.LifecycleSupport;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigTreeBuilder;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigurationTree;

public final class ConfigurationContext {
    private Bootstrap bootstrap;
    private Configuration configuration;
    private ConfigurationTree configurationTree;
    private Environment environment;
    private final Multimap<ConfigItem, Object> itemsHolder = LinkedHashMultimap.create();
    private final Map<Class<?>, ItemInfo> detailsHolder = Maps.newHashMap();
    private final Multimap<ConfigItem, Class<?>> disabledItemsHolder = LinkedHashMultimap.create();
    private final Multimap<Class<?>, Class<?>> disabledByHolder = LinkedHashMultimap.create();
    private final List<PredicateHandler> disablePredicates = new ArrayList<PredicateHandler>();
    private Class<?> currentScope;
    private final StatsTracker tracker = new StatsTracker();
    private final OptionsSupport optionsSupport = new OptionsSupport();
    private final LifecycleSupport lifecycleTracker = new LifecycleSupport(new Options(this.optionsSupport));

    public void setScope(Class<?> scope) {
        Preconditions.checkState((this.currentScope == null ? 1 : 0) != 0, (Object)"State error: current scope not closed");
        this.currentScope = scope;
    }

    public void closeScope() {
        Preconditions.checkState((this.currentScope != null ? 1 : 0) != 0, (Object)"State error: trying to close not opened scope");
        this.currentScope = null;
    }

    public void registerCommands(List<Class<Command>> commands) {
        this.setScope(ConfigScope.ClasspathScan.getType());
        for (Class<Command> cmd : commands) {
            this.register(ConfigItem.Command, cmd);
        }
        this.closeScope();
    }

    public void registerDwBundles(List<GuiceyBundle> bundles) {
        this.setScope(ConfigScope.DropwizardBundle.getType());
        for (GuiceyBundle bundle : bundles) {
            this.register(ConfigItem.Bundle, bundle);
        }
        this.closeScope();
        this.lifecycle().bundlesFromDwResolved(bundles);
    }

    public void registerLookupBundles(List<GuiceyBundle> bundles) {
        this.setScope(ConfigScope.BundleLookup.getType());
        for (GuiceyBundle bundle : bundles) {
            this.register(ConfigItem.Bundle, bundle);
        }
        this.closeScope();
        this.lifecycle().bundlesFromLookupResolved(bundles);
        this.lifecycle().bundlesResolved(this.getEnabledBundles(), this.getDisabledBundles());
    }

    public void registerBundles(GuiceyBundle ... bundles) {
        for (GuiceyBundle bundle : bundles) {
            this.register(ConfigItem.Bundle, bundle);
        }
    }

    public void disableBundle(Class<? extends GuiceyBundle>[] bundles) {
        for (Class<? extends GuiceyBundle> bundle : bundles) {
            this.registerDisable(ConfigItem.Bundle, bundle);
        }
    }

    public List<GuiceyBundle> getEnabledBundles() {
        return this.getEnabledItems(ConfigItem.Bundle);
    }

    public List<GuiceyBundle> getDisabledBundles() {
        return this.getDisabledItems(ConfigItem.Bundle);
    }

    public boolean isBundleEnabled(Class<? extends GuiceyBundle> type) {
        return this.isEnabled(ConfigItem.Bundle, type);
    }

    public void registerModules(Module ... modules) {
        for (Module module : modules) {
            this.register(ConfigItem.Module, module);
        }
    }

    public void registerModulesOverride(Module ... modules) {
        ModuleItemInfoImpl.overrideScope(() -> {
            for (Module module : modules) {
                this.register(ConfigItem.Module, module);
            }
        });
    }

    public void disableModules(Class<? extends Module>[] modules) {
        for (Class<? extends Module> module : modules) {
            this.registerDisable(ConfigItem.Module, module);
        }
    }

    public List<Module> getEnabledModules() {
        return this.getEnabledItems(ConfigItem.Module);
    }

    public List<Module> getNormalModules() {
        return this.getEnabledModules().stream().filter(mod -> !((ModuleItemInfo)this.getInfo(mod)).isOverriding()).collect(Collectors.toList());
    }

    public List<Module> getOverridingModules() {
        return this.getEnabledModules().stream().filter(mod -> ((ModuleItemInfo)this.getInfo(mod)).isOverriding()).collect(Collectors.toList());
    }

    public List<Module> getDisabledModules() {
        return this.getDisabledItems(ConfigItem.Module);
    }

    public void registerInstallers(Class<? extends FeatureInstaller>[] installers) {
        for (Class<? extends FeatureInstaller> installer : installers) {
            this.register(ConfigItem.Installer, installer);
        }
    }

    public void registerInstallersFromScan(List<Class<? extends FeatureInstaller>> installers) {
        this.setScope(ConfigScope.ClasspathScan.getType());
        for (Class<? extends FeatureInstaller> installer : installers) {
            this.register(ConfigItem.Installer, installer);
        }
        this.closeScope();
    }

    public void disableInstallers(Class<? extends FeatureInstaller>[] installers) {
        for (Class<? extends FeatureInstaller> installer : installers) {
            this.registerDisable(ConfigItem.Installer, installer);
        }
    }

    public List<Class<? extends FeatureInstaller>> getEnabledInstallers() {
        return this.getEnabledItems(ConfigItem.Installer);
    }

    public List<Class<? extends FeatureInstaller>> getDisabledInstallers() {
        return this.getDisabledItems(ConfigItem.Installer);
    }

    public void registerExtensions(Class<?> ... extensions) {
        for (Class<?> extension : extensions) {
            this.register(ConfigItem.Extension, extension);
        }
    }

    public ExtensionItemInfoImpl getOrRegisterExtension(Class<?> extension, boolean fromScan) {
        ExtensionItemInfoImpl info;
        if (fromScan) {
            this.setScope(ConfigScope.ClasspathScan.getType());
            info = (ExtensionItemInfoImpl)this.register(ConfigItem.Extension, extension);
            this.closeScope();
        } else {
            info = (ExtensionItemInfoImpl)this.getInfo(extension);
        }
        return info;
    }

    public void disableExtensions(Class<?>[] extensions) {
        for (Class<?> extension : extensions) {
            this.registerDisable(ConfigItem.Extension, extension);
        }
    }

    public boolean isExtensionEnabled(Class<?> extension) {
        return this.isEnabled(ConfigItem.Extension, extension);
    }

    public List<Class<?>> getEnabledExtensions() {
        return this.getEnabledItems(ConfigItem.Extension);
    }

    public List<Class<?>> getDisabledExtensions() {
        return this.getDisabledItems(ConfigItem.Extension);
    }

    public <T extends Enum> void setOption(T option, Object value) {
        this.optionsSupport.set(option, value);
    }

    public <V, T extends Enum> V option(T option) {
        return (V)this.optionsSupport.get(option);
    }

    public OptionsSupport options() {
        return this.optionsSupport;
    }

    public void registerDisablePredicates(Predicate<ItemInfo>[] predicates) {
        List<PredicateHandler> list = Arrays.stream(predicates).map(p -> new PredicateHandler((Predicate<ItemInfo>)p, this.getScope())).collect(Collectors.toList());
        this.disablePredicates.addAll(list);
        this.applyPredicatesForRegisteredItems(list);
    }

    public void runHooks(GuiceBundle.Builder builder) {
        this.setScope(ConfigScope.Hook.getType());
        Set<GuiceyConfigurationHook> hooks = ConfigurationHooksSupport.run(builder);
        this.closeScope();
        this.lifecycle().configurationHooksProcessed(hooks);
    }

    public void initPhaseStarted(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    public void runPhaseStarted(Configuration configuration, Environment environment) {
        this.configuration = configuration;
        this.configurationTree = ConfigTreeBuilder.build(this.bootstrap, configuration, (Boolean)this.option(GuiceyOptions.BindConfigurationByPath));
        this.environment = environment;
    }

    public void finalizeConfiguration() {
        for (ConfigItem type : this.disabledItemsHolder.keys()) {
            for (Class item : this.disabledItemsHolder.get((Object)type)) {
                DisableSupport info = (DisableSupport)this.getOrCreateInfo(type, item);
                info.getDisabledBy().addAll(this.disabledByHolder.get(this.getType(item)));
            }
        }
    }

    public <T> List<T> getItems(ConfigItem type) {
        Collection res = this.itemsHolder.get((Object)type);
        return res.isEmpty() ? Collections.emptyList() : Lists.newArrayList((Iterable)res);
    }

    public <T> List<T> getItems(ConfigItem type, Predicate<T> filter) {
        Collection items = this.itemsHolder.get((Object)type);
        if (items.isEmpty()) {
            return Collections.emptyList();
        }
        return items.stream().filter(filter).collect(Collectors.toList());
    }

    public <T extends ItemInfoImpl> T getInfo(Object item) {
        Class<?> itemType = this.getType(item);
        return (T)((ItemInfoImpl)this.detailsHolder.get(itemType));
    }

    public StatsTracker stat() {
        return this.tracker;
    }

    public LifecycleSupport lifecycle() {
        return this.lifecycleTracker;
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ConfigurationTree getConfigurationTree() {
        return this.configurationTree;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    private Class<?> getScope() {
        return this.currentScope == null ? ConfigScope.Application.getType() : this.currentScope;
    }

    private void applyPredicatesForRegisteredItems(List<PredicateHandler> predicates) {
        ImmutableList.builder().addAll(this.getEnabledModules()).addAll(this.getEnabledBundles()).addAll(this.getEnabledExtensions()).addAll(this.getEnabledInstallers()).build().stream().map(this::getInfo).forEach(item -> this.applyDisablePredicates(predicates, (ItemInfo)item));
    }

    private void registerDisable(ConfigItem type, Class<?> item) {
        this.disabledItemsHolder.put((Object)type, item);
        this.disabledByHolder.put(item, this.getScope());
    }

    private <T extends ItemInfoImpl> T register(ConfigItem type, Object item) {
        T info = this.getOrCreateInfo(type, item);
        ((ItemInfoImpl)info).countRegistrationAttempt();
        ((ItemInfoImpl)info).getRegisteredBy().add(this.getScope());
        if (((ItemInfoImpl)info).getRegistrationScope() == null) {
            ((ItemInfoImpl)info).setRegistrationScope(this.getScope());
        }
        this.fireRegistration((ItemInfo)info);
        return info;
    }

    private void fireRegistration(ItemInfo item) {
        if (item instanceof DisableSupport && item.getRegistrationAttempts() == 1) {
            this.applyDisablePredicates(this.disablePredicates, item);
        }
    }

    private void applyDisablePredicates(List<PredicateHandler> predicates, ItemInfo item) {
        for (PredicateHandler predicate : predicates) {
            if (predicate.disable(item)) break;
        }
    }

    private <T extends ItemInfoImpl> T getOrCreateInfo(ConfigItem type, Object item) {
        ItemInfoImpl info;
        Class<?> itemType = this.getType(item);
        if (this.detailsHolder.containsKey(itemType)) {
            info = (ItemInfoImpl)this.detailsHolder.get(itemType);
        } else {
            this.itemsHolder.put((Object)type, item);
            info = type.newContainer(itemType);
            this.detailsHolder.put(itemType, info);
        }
        return (T)info;
    }

    private Class<?> getType(Object item) {
        return item instanceof Class ? (Class<?>)item : item.getClass();
    }

    private <T> List<T> getDisabledItems(ConfigItem type) {
        Collection disabled = this.disabledItemsHolder.get((Object)type);
        return disabled.isEmpty() ? Collections.emptyList() : this.getItems(type, item -> disabled.contains(this.getType(item)));
    }

    private <T> List<T> getEnabledItems(ConfigItem type) {
        Collection disabled = this.disabledItemsHolder.get((Object)type);
        return disabled.isEmpty() ? this.getItems(type) : this.getItems(type, item -> !disabled.contains(this.getType(item)));
    }

    private boolean isEnabled(ConfigItem type, Class itemType) {
        return !this.disabledItemsHolder.get((Object)type).contains(itemType);
    }

    private class PredicateHandler {
        private final Class<?> predicateScope;
        private final Predicate<ItemInfo> predicate;

        PredicateHandler(Predicate<ItemInfo> predicate, Class<?> predicateScope) {
            this.predicate = predicate;
            this.predicateScope = predicateScope;
        }

        public boolean disable(ItemInfo item) {
            boolean test = this.predicate.test(item);
            if (test) {
                Class scope = ConfigurationContext.this.currentScope;
                ConfigurationContext.this.currentScope = this.predicateScope;
                ConfigurationContext.this.registerDisable(item.getItemType(), item.getType());
                ConfigurationContext.this.currentScope = scope;
            }
            return test;
        }
    }
}

