/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context.debug;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import io.dropwizard.Application;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import ru.vyarus.dropwizard.guice.injector.lookup.InjectorLookup;
import ru.vyarus.dropwizard.guice.module.context.debug.report.DiagnosticReporter;
import ru.vyarus.dropwizard.guice.module.context.debug.report.diagnostic.DiagnosticConfig;
import ru.vyarus.dropwizard.guice.module.context.debug.report.diagnostic.DiagnosticRenderer;
import ru.vyarus.dropwizard.guice.module.context.debug.report.option.OptionsConfig;
import ru.vyarus.dropwizard.guice.module.context.debug.report.option.OptionsRenderer;
import ru.vyarus.dropwizard.guice.module.context.debug.report.stat.StatsRenderer;
import ru.vyarus.dropwizard.guice.module.context.debug.report.tree.ContextTreeConfig;
import ru.vyarus.dropwizard.guice.module.context.debug.report.tree.ContextTreeRenderer;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBootstrap;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;

public class DiagnosticBundle
implements GuiceyBundle {
    private final Boolean statsConfig;
    private final OptionsConfig optionsConfig;
    private final DiagnosticConfig config;
    private final ContextTreeConfig treeConfig;

    public DiagnosticBundle() {
        this(DiagnosticBundle.builder().printStartupStats(true).printOptions(new OptionsConfig().showNotDefinedOptions().showNotUsedMarker()).printConfiguration(new DiagnosticConfig().printDefaults()).printContextTree(new ContextTreeConfig().hideNotUsedInstallers().hideEmptyBundles().hideCommands()));
    }

    DiagnosticBundle(Builder builder) {
        this.statsConfig = builder.statsConfig;
        this.optionsConfig = builder.optionsConfig;
        this.config = builder.config;
        this.treeConfig = builder.treeConfig;
    }

    @Override
    public void initialize(final GuiceyBootstrap bootstrap) {
        bootstrap.environment().lifecycle().addLifeCycleListener((LifeCycle.Listener)new AbstractLifeCycle.AbstractLifeCycleListener(){

            public void lifeCycleStarted(LifeCycle event) {
                DiagnosticBundle.this.report(bootstrap.application());
            }
        });
        bootstrap.modules(new Module[]{new DiagnosticModule()});
    }

    private void report(Application app) {
        DiagnosticReporter reporter = new DiagnosticReporter();
        InjectorLookup.getInjector(app).get().injectMembers((Object)reporter);
        reporter.report(this.statsConfig, this.optionsConfig, this.config, this.treeConfig);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class DiagnosticModule
    extends AbstractModule {
        protected void configure() {
            this.bind(StatsRenderer.class);
            this.bind(OptionsRenderer.class);
            this.bind(DiagnosticRenderer.class);
            this.bind(ContextTreeRenderer.class);
        }
    }

    public static class Builder {
        private Boolean statsConfig;
        private OptionsConfig optionsConfig;
        private DiagnosticConfig config;
        private ContextTreeConfig treeConfig;

        public Builder printStartupStats(boolean hideSmallTimes) {
            this.statsConfig = hideSmallTimes;
            return this;
        }

        public Builder printOptions(OptionsConfig config) {
            this.optionsConfig = config;
            return this;
        }

        public Builder printConfiguration(DiagnosticConfig config) {
            this.config = config;
            Preconditions.checkState((!config.isEmptyConfig() ? 1 : 0) != 0, (Object)"Empty config provided. Use at least one print option.");
            return this;
        }

        public Builder printContextTree(ContextTreeConfig treeConfig) {
            this.treeConfig = treeConfig;
            return this;
        }

        public DiagnosticBundle build() {
            return new DiagnosticBundle(this);
        }
    }
}

