/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context.debug.report;

import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.context.debug.report.ReportRenderer;
import ru.vyarus.dropwizard.guice.module.context.debug.report.diagnostic.DiagnosticConfig;
import ru.vyarus.dropwizard.guice.module.context.debug.report.diagnostic.DiagnosticRenderer;
import ru.vyarus.dropwizard.guice.module.context.debug.report.option.OptionsConfig;
import ru.vyarus.dropwizard.guice.module.context.debug.report.option.OptionsRenderer;
import ru.vyarus.dropwizard.guice.module.context.debug.report.stat.StatsRenderer;
import ru.vyarus.dropwizard.guice.module.context.debug.report.tree.ContextTreeConfig;
import ru.vyarus.dropwizard.guice.module.context.debug.report.tree.ContextTreeRenderer;

public final class DiagnosticReporter {
    private final Logger logger = LoggerFactory.getLogger(DiagnosticReporter.class);
    @Inject
    private StatsRenderer statsRenderer;
    @Inject
    private OptionsRenderer optionsRenderer;
    @Inject
    private DiagnosticRenderer diagnosticRenderer;
    @Inject
    private ContextTreeRenderer contextTreeRenderer;

    public void report(Boolean statsConfig, OptionsConfig optionsConfig, DiagnosticConfig config, ContextTreeConfig treeConfig) {
        this.report("Startup stats = {}", this.statsRenderer, statsConfig);
        this.report("Options = {}", this.optionsRenderer, optionsConfig);
        this.report("Configuration diagnostic info = {}", this.diagnosticRenderer, config);
        this.report("Configuration context tree = {}", this.contextTreeRenderer, treeConfig);
    }

    private <T> void report(String name, ReportRenderer<T> renderer, T config) {
        if (config != null) {
            this.logger.info(name, (Object)renderer.renderReport(config));
        }
    }
}

