/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context.debug.report.tree;

import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import ru.vyarus.dropwizard.guice.module.GuiceyConfigurationInfo;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.ConfigScope;
import ru.vyarus.dropwizard.guice.module.context.Filters;
import ru.vyarus.dropwizard.guice.module.context.debug.report.ReportRenderer;
import ru.vyarus.dropwizard.guice.module.context.debug.report.tree.ContextTreeConfig;
import ru.vyarus.dropwizard.guice.module.context.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.module.context.debug.util.TreeNode;
import ru.vyarus.dropwizard.guice.module.context.info.BundleItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.ItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.sign.DisableSupport;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

@Singleton
public class ContextTreeRenderer
implements ReportRenderer<ContextTreeConfig> {
    private static final String IGNORED = "IGNORED";
    private final GuiceyConfigurationInfo service;

    @Inject
    public ContextTreeRenderer(GuiceyConfigurationInfo service) {
        this.service = service;
    }

    @Override
    public String renderReport(ContextTreeConfig config) {
        Set<Class<?>> scopes = this.service.getActiveScopes(!config.isHideDisables());
        TreeNode root = new TreeNode("APPLICATION", new Object[0]);
        if (!config.getHiddenScopes().contains(ConfigScope.Application.getType())) {
            this.renderScopeContent(config, root, ConfigScope.Application.getType());
        }
        this.renderSpecialScope(config, scopes, root, "BUNDLES LOOKUP", ConfigScope.BundleLookup);
        this.renderSpecialScope(config, scopes, root, "DROPWIZARD BUNDLES", ConfigScope.DropwizardBundle);
        this.renderSpecialScope(config, scopes, root, "CLASSPATH SCAN", ConfigScope.ClasspathScan);
        this.renderSpecialScope(config, scopes, root, "HOOKS", ConfigScope.Hook);
        StringBuilder res = new StringBuilder().append(Reporter.NEWLINE).append(Reporter.NEWLINE);
        root.render(res);
        return res.toString();
    }

    private void renderSpecialScope(ContextTreeConfig config, Set<Class<?>> scopes, TreeNode root, String name, ConfigScope scope) {
        if (this.isScopeVisible(config, scopes, scope.getType())) {
            TreeNode node = new TreeNode(name, new Object[0]);
            this.renderScopeContent(config, node, scope.getType());
            if (node.hasChildren()) {
                root.child(node);
            }
        }
    }

    private void renderScopeContent(ContextTreeConfig config, TreeNode root, Class<?> scope) {
        this.renderScopeItems(config, root, scope);
        List<Class<Object>> bundles = this.service.getData().getItems(Filters.registeredBy(scope).and(Filters.type(ConfigItem.Bundle)));
        for (Class<Object> bundle : bundles) {
            this.renderBundle(config, root, scope, bundle);
        }
    }

    private void renderScopeItems(ContextTreeConfig config, TreeNode root, Class<?> scope) {
        List<Class<Object>> items = this.service.getData().getItems(Filters.registeredBy(scope).and(Filters.type(ConfigItem.Bundle).negate()));
        ArrayList markers = Lists.newArrayList();
        for (Class<Object> item : items) {
            markers.clear();
            Object info = this.service.getData().getInfo(item);
            if (this.isHidden(config, (ItemInfo)info, scope)) continue;
            this.fillCommonMarkers((ItemInfo)info, markers, scope);
            this.renderLeaf(root, info.getItemType().name().toLowerCase(), item, markers);
        }
        if (!config.isHideDisables()) {
            List<Class<Object>> disabled = this.service.getData().getItems(Filters.disabledBy(scope));
            for (Class<Object> item : disabled) {
                this.renderLeaf(root, "-disable", item, null);
            }
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_INFERRED"})
    private void renderLeaf(TreeNode root, String name, Class<?> item, List<String> markers) {
        root.child(String.format("%-10s ", name) + RenderUtils.renderClassLine(item, markers), new Object[0]);
    }

    private void renderBundle(ContextTreeConfig config, TreeNode root, Class<?> scope, Class<Object> bundle) {
        BundleItemInfo info = (BundleItemInfo)this.service.getData().getInfo(bundle);
        if (this.isHidden(config, info, scope)) {
            return;
        }
        ArrayList markers = Lists.newArrayList();
        this.fillCommonMarkers(info, markers, scope);
        TreeNode node = new TreeNode(RenderUtils.renderClassLine(bundle, markers), new Object[0]);
        if (!this.isDuplicateRegistration(info, scope)) {
            this.renderScopeContent(config, node, bundle);
        }
        if (node.hasChildren() || !config.isHideEmptyBundles() || !config.isHideDisables() && markers.contains(IGNORED)) {
            root.child(node);
        }
    }

    private void fillCommonMarkers(ItemInfo info, List<String> markers, Class<?> scope) {
        if (this.isDuplicateRegistration(info, scope)) {
            markers.add(IGNORED);
        }
        if (this.isDisabled(info)) {
            markers.add("DISABLED");
        }
    }

    private boolean isScopeVisible(ContextTreeConfig config, Set<Class<?>> scopes, Class<?> scope) {
        return !config.getHiddenScopes().contains(scope) && (scopes == null || scopes.contains(scope));
    }

    private boolean isHidden(ContextTreeConfig config, ItemInfo info, Class<?> scope) {
        boolean hidden = config.getHiddenItems().contains((Object)info.getItemType());
        boolean disabled = config.isHideDisables() && this.isDisabled(info);
        boolean ignored = config.isHideDuplicateRegistrations() && this.isDuplicateRegistration(info, scope);
        boolean hiddenScope = !this.isScopeVisible(config, null, scope) || this.isHiddenBundle(config, info);
        boolean notUsedInstaller = config.isHideNotUsedInstallers() && this.isNotUsedInstaller(info);
        return hidden || disabled || ignored || hiddenScope || notUsedInstaller;
    }

    private boolean isHiddenBundle(ContextTreeConfig config, ItemInfo info) {
        return ConfigItem.Bundle.equals((Object)info.getItemType()) && !this.isScopeVisible(config, null, info.getType());
    }

    private boolean isNotUsedInstaller(ItemInfo info) {
        return info.getItemType() == ConfigItem.Installer && this.service.getExtensions(info.getType()).isEmpty();
    }

    private boolean isDisabled(ItemInfo item) {
        return item instanceof DisableSupport && !((DisableSupport)((Object)item)).isEnabled();
    }

    private boolean isDuplicateRegistration(ItemInfo item, Class<?> scope) {
        return !scope.equals(item.getRegistrationScope());
    }
}

