/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context.debug.util;

import ch.qos.logback.classic.pattern.TargetLengthBasedClassNameAbbreviator;
import com.google.common.base.Joiner;
import java.util.List;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;

public final class RenderUtils {
    private static final TargetLengthBasedClassNameAbbreviator PACKAGE_FORMATTER = new TargetLengthBasedClassNameAbbreviator(20);
    private static final TargetLengthBasedClassNameAbbreviator CLASS_FORMATTER = new TargetLengthBasedClassNameAbbreviator(36);

    private RenderUtils() {
    }

    public static String renderInstaller(Class<FeatureInstaller> type, List<String> markers) {
        return String.format("%-20s %-38s %s", FeatureUtils.getInstallerExtName(type), RenderUtils.brackets(RenderUtils.renderClass(type)), RenderUtils.markers(markers));
    }

    public static String renderDisabledInstaller(Class<FeatureInstaller> type) {
        return String.format("-%-19s %-38s", FeatureUtils.getInstallerExtName(type), RenderUtils.brackets(RenderUtils.renderClass(type)));
    }

    public static String renderClassLine(Class<?> type, List<String> markers) {
        return String.format("%-28s %-26s %s", RenderUtils.getClassName(type), RenderUtils.brackets(RenderUtils.renderPackage(type)), RenderUtils.markers(markers));
    }

    public static String renderDisabledClassLine(Class<?> type) {
        return String.format("-%-27s %-26s", RenderUtils.getClassName(type), RenderUtils.brackets(RenderUtils.renderPackage(type)));
    }

    public static String renderClass(Class<?> type) {
        return CLASS_FORMATTER.abbreviate(type.getName());
    }

    public static String renderPackage(Class<?> type) {
        return PACKAGE_FORMATTER.abbreviate(type.isMemberClass() && !type.isAnonymousClass() ? type.getDeclaringClass().getName() : type.getPackage().getName());
    }

    public static String brackets(String string) {
        return "(" + string + ")";
    }

    public static String markers(List<String> markers) {
        String signs = "";
        if (markers != null && !markers.isEmpty()) {
            signs = "*" + Joiner.on((String)", ").join(markers);
        }
        return signs;
    }

    private static String getClassName(Class<?> type) {
        String name = type.getSimpleName();
        if (name.isEmpty()) {
            name = type.getName().substring(type.getName().lastIndexOf(46) + 1);
        }
        return name;
    }
}

