/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.feature.jersey;

import com.google.inject.Binder;
import com.google.inject.ScopeAnnotation;
import com.google.inject.binder.AnnotatedBindingBuilder;
import java.lang.annotation.Annotation;
import javax.inject.Scope;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.InstallersOptions;
import ru.vyarus.dropwizard.guice.module.installer.install.JerseyInstaller;
import ru.vyarus.dropwizard.guice.module.installer.option.InstallerOptionsSupport;
import ru.vyarus.dropwizard.guice.module.installer.util.JerseyBinding;

public abstract class AbstractJerseyInstaller<T>
extends InstallerOptionsSupport
implements FeatureInstaller<T>,
JerseyInstaller<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected boolean isLazy(Class<?> type, boolean lazy) {
        if (this.isHkExtension(type) && lazy) {
            this.logger.warn("@LazyBinding is ignored, because @HK2Managed set: {}", (Object)type.getName());
            return false;
        }
        return lazy;
    }

    protected boolean isHkExtension(Class<?> type) {
        return JerseyBinding.isHK2Managed(type, (Boolean)this.option(InstallersOptions.JerseyExtensionsManagedByGuice));
    }

    protected void bindInGuice(Binder binder, Class<?> type) {
        AnnotatedBindingBuilder binding = binder.bind(type);
        if (this.isForceSingleton(type, false)) {
            binding.in(Singleton.class);
        }
    }

    protected boolean isForceSingleton(Class<?> type, boolean hkManaged) {
        return (Boolean)this.option(InstallersOptions.ForceSingletonForJerseyExtensions) != false && !this.hasScopeAnnotation(type, hkManaged);
    }

    private boolean hasScopeAnnotation(Class<?> type, boolean hkManaged) {
        boolean found = false;
        for (Annotation ann : type.getAnnotations()) {
            Class<? extends Annotation> annType = ann.annotationType();
            if (annType.isAnnotationPresent(Scope.class)) {
                found = true;
                break;
            }
            if (hkManaged || !annType.isAnnotationPresent(ScopeAnnotation.class)) continue;
            found = true;
            break;
        }
        return found;
    }
}

