/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.feature.jersey.provider;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.Injector;
import java.util.Set;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;
import ru.vyarus.dropwizard.guice.module.installer.feature.jersey.AbstractJerseyInstaller;
import ru.vyarus.dropwizard.guice.module.installer.feature.jersey.provider.ProviderReporter;
import ru.vyarus.dropwizard.guice.module.installer.install.binding.BindingInstaller;
import ru.vyarus.dropwizard.guice.module.installer.order.Order;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.JerseyBinding;
import ru.vyarus.java.generics.resolver.GenericsResolver;

@Order(value=30)
public class JerseyProviderInstaller
extends AbstractJerseyInstaller<Object>
implements BindingInstaller {
    private static final Set<Class<?>> EXTENSION_TYPES = ImmutableSet.of(ExceptionMapper.class, ParamConverterProvider.class, ContextResolver.class, MessageBodyReader.class, MessageBodyWriter.class, ReaderInterceptor.class, (Object[])new Class[]{WriterInterceptor.class, ContainerRequestFilter.class, ContainerResponseFilter.class, DynamicFeature.class, ValueFactoryProvider.class, InjectionResolver.class, ApplicationEventListener.class});
    private final ProviderReporter reporter = new ProviderReporter();

    @Override
    public boolean matches(Class<?> type) {
        return FeatureUtils.hasAnnotation(type, Provider.class);
    }

    @Override
    public <T> void install(Binder binder, Class<? extends T> type, boolean lazyMarker) {
        boolean hkManaged = this.isHkExtension(type);
        boolean lazy = this.isLazy(type, lazyMarker);
        if (!hkManaged && !lazy) {
            this.bindInGuice(binder, type);
        }
        this.reporter.provider(type, hkManaged, lazy);
    }

    @Override
    public void install(AbstractBinder binder, Injector injector, Class<Object> type) {
        boolean hkExtension = this.isHkExtension(type);
        boolean forceSingleton = this.isForceSingleton(type, hkExtension);
        if (FeatureUtils.is(type, Factory.class)) {
            JerseyBinding.bindFactory(binder, injector, type, hkExtension, forceSingleton);
        } else {
            Sets.SetView extensions = Sets.intersection(EXTENSION_TYPES, (Set)GenericsResolver.resolve(type, (Class[])new Class[0]).getGenericsInfo().getComposingTypes());
            if (!extensions.isEmpty()) {
                for (Class ext : extensions) {
                    JerseyBinding.bindSpecificComponent(binder, injector, type, ext, hkExtension, forceSingleton);
                }
            } else {
                JerseyBinding.bindComponent(binder, injector, type, hkExtension, forceSingleton);
            }
        }
    }

    @Override
    public void report() {
        this.reporter.report();
    }
}

