/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import ru.vyarus.dropwizard.guice.module.context.stat.StatsTracker;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.order.OrderComparator;
import ru.vyarus.dropwizard.guice.module.installer.order.Ordered;
import ru.vyarus.dropwizard.guice.module.lifecycle.internal.LifecycleSupport;

public class ExtensionsHolder {
    private final List<FeatureInstaller> installers;
    private final List<Class<? extends FeatureInstaller>> installerTypes;
    private final Map<Class<? extends FeatureInstaller>, List<Class<?>>> extensions = Maps.newHashMap();
    private final StatsTracker tracker;
    private final LifecycleSupport lifecycleTracker;

    public ExtensionsHolder(List<FeatureInstaller> installers, StatsTracker tracker, LifecycleSupport lifecycleTracker) {
        this.installers = installers;
        this.tracker = tracker;
        this.lifecycleTracker = lifecycleTracker;
        this.installerTypes = Lists.transform(installers, Object::getClass);
    }

    public void register(Class<? extends FeatureInstaller> installer, Class extension) {
        Preconditions.checkArgument((boolean)this.installerTypes.contains(installer), (String)"Installer %s not registered", (Object)installer.getSimpleName());
        if (!this.extensions.containsKey(installer)) {
            this.extensions.put(installer, Lists.newArrayList());
        }
        this.extensions.get(installer).add(extension);
    }

    public List<FeatureInstaller> getInstallers() {
        return this.installers;
    }

    public List<Class<? extends FeatureInstaller>> getInstallerTypes() {
        return this.installerTypes;
    }

    public List<Class<?>> getExtensions(Class<? extends FeatureInstaller> installer) {
        return this.extensions.get(installer);
    }

    public void order() {
        OrderComparator comparator = new OrderComparator();
        for (Class<? extends FeatureInstaller> installer : this.installerTypes) {
            List<Class<?>> extensions;
            if (!Ordered.class.isAssignableFrom(installer) || (extensions = this.extensions.get(installer)) == null || extensions.size() <= 1) continue;
            extensions.sort(comparator);
        }
    }

    protected StatsTracker stat() {
        return this.tracker;
    }

    protected LifecycleSupport lifecycle() {
        return this.lifecycleTracker;
    }
}

