/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.jersey.hk2;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.servlet.RequestScoped;
import javax.inject.Provider;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.process.AsyncContext;
import ru.vyarus.dropwizard.guice.module.installer.util.JerseyBinding;

public class GuiceBindingsModule
extends AbstractModule {
    private final Provider<Injector> provider;
    private final boolean guiceServletSupport;

    public GuiceBindingsModule(Provider<Injector> provider, boolean guiceServletSupport) {
        this.provider = provider;
        this.guiceServletSupport = guiceServletSupport;
    }

    protected void configure() {
        this.jerseyToGuiceGlobal(MultivaluedParameterExtractorProvider.class);
        this.jerseyToGuiceGlobal(Application.class);
        this.jerseyToGuiceGlobal(Providers.class);
        this.jerseyToGuice(UriInfo.class);
        this.jerseyToGuice(ResourceInfo.class);
        this.jerseyToGuice(HttpHeaders.class);
        this.jerseyToGuice(SecurityContext.class);
        this.jerseyToGuice(Request.class);
        this.jerseyToGuice(ContainerRequest.class);
        this.jerseyToGuice(AsyncContext.class);
        if (!this.guiceServletSupport) {
            this.jerseyToGuice(HttpServletRequest.class);
            this.jerseyToGuice(HttpServletResponse.class);
        }
    }

    private void jerseyToGuiceGlobal(Class<?> type) {
        this.jerseyToGuiceBinding(type, true);
    }

    private void jerseyToGuice(Class<?> type) {
        this.jerseyToGuiceBinding(type, false);
    }

    private void jerseyToGuiceBinding(Class<?> type, boolean global) {
        ScopedBindingBuilder binding = JerseyBinding.bindJerseyComponent(this.binder(), this.provider, type);
        if (!global && this.guiceServletSupport) {
            binding.in(RequestScoped.class);
        }
    }
}

