/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.lifecycle.event;

import io.dropwizard.Configuration;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import ru.vyarus.dropwizard.guice.module.context.option.Options;
import ru.vyarus.dropwizard.guice.module.lifecycle.GuiceyLifecycle;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.GuiceyLifecycleEvent;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigurationTree;
import ru.vyarus.dropwizard.guice.module.yaml.report.BindingsConfig;
import ru.vyarus.dropwizard.guice.module.yaml.report.ConfigBindingsRenderer;

public abstract class RunPhaseEvent
extends GuiceyLifecycleEvent {
    private final Bootstrap bootstrap;
    private final Configuration configuration;
    private final ConfigurationTree configurationTree;
    private final Environment environment;

    public RunPhaseEvent(GuiceyLifecycle type, Options options, Bootstrap bootstrap, Configuration configuration, ConfigurationTree configurationTree, Environment environment) {
        super(type, options);
        this.bootstrap = bootstrap;
        this.configuration = configuration;
        this.configurationTree = configurationTree;
        this.environment = environment;
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    public <T extends Configuration> T getConfiguration() {
        return (T)this.configuration;
    }

    public ConfigurationTree getConfigurationTree() {
        return this.configurationTree;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public String renderConfigurationBindings(BindingsConfig config) {
        return new ConfigBindingsRenderer(this.configurationTree).renderReport(config);
    }
}

