/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.yaml.bind;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.util.Providers;
import io.dropwizard.Configuration;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigPath;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigurationTree;
import ru.vyarus.dropwizard.guice.module.yaml.bind.Config;
import ru.vyarus.dropwizard.guice.module.yaml.bind.ConfigImpl;

public class ConfigBindingModule
extends AbstractModule {
    private final Configuration configuration;
    private final ConfigurationTree tree;
    private final boolean bindInterfaces;

    public ConfigBindingModule(Configuration configuration, ConfigurationTree tree, boolean bindInterfaces) {
        this.configuration = configuration;
        this.tree = tree;
        this.bindInterfaces = bindInterfaces;
    }

    protected void configure() {
        this.bind(ConfigurationTree.class).toInstance((Object)this.tree);
        this.bindRootTypes();
        this.bindUniqueSubConfigurations();
        this.bindValuePaths();
    }

    private void bindRootTypes() {
        for (Class type : this.tree.getRootTypes()) {
            if (!type.isInterface() || this.bindInterfaces) {
                this.bind(type).toInstance((Object)this.configuration);
            }
            this.bind(type).annotatedWith(Config.class).toInstance((Object)this.configuration);
        }
    }

    private void bindUniqueSubConfigurations() {
        for (ConfigPath item : this.tree.getUniqueTypePaths()) {
            this.toValue(this.bind(Key.get((Type)item.getDeclaredTypeWithGenerics(), Config.class)), item.getValue());
        }
    }

    private void bindValuePaths() {
        for (ConfigPath item : this.tree.getPaths()) {
            this.toValue(this.bind(Key.get((Type)item.getDeclaredTypeWithGenerics(), (Annotation)new ConfigImpl(item.getPath()))), item.getValue());
        }
    }

    private void toValue(LinkedBindingBuilder binding, Object value) {
        if (value != null) {
            binding.toInstance(value);
        } else {
            binding.toProvider(Providers.of(null));
        }
    }
}

