/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.yaml.report;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;
import ru.vyarus.dropwizard.guice.module.lifecycle.GuiceyLifecycleAdapter;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.BeforeRunEvent;
import ru.vyarus.dropwizard.guice.module.yaml.report.BindingsConfig;
import ru.vyarus.dropwizard.guice.module.yaml.report.ConfigBindingsRenderer;

public class DebugConfigBindings
extends GuiceyLifecycleAdapter {
    private final Logger logger = LoggerFactory.getLogger(DebugConfigBindings.class);
    private final BindingsConfig config;

    public DebugConfigBindings(BindingsConfig config) {
        this.config = config;
    }

    @Override
    protected void beforeRun(BeforeRunEvent event) {
        boolean customOnly = this.config.isShowCustomConfigOnly();
        String report = customOnly && event.getConfigurationTree().getRootTypes().size() == 1 ? Reporter.NEWLINE + Reporter.NEWLINE + "    " + "No custom bindings" : new ConfigBindingsRenderer(event.getConfigurationTree()).renderReport(this.config);
        this.logger.info("Available {}configuration bindings = {}", (Object)(customOnly ? "custom " : ""), (Object)report);
    }
}

