/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.cli.Command;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.servlet.DispatcherType;
import ru.vyarus.dropwizard.guice.GuiceyOptions;
import ru.vyarus.dropwizard.guice.bundle.DefaultBundleLookup;
import ru.vyarus.dropwizard.guice.bundle.GuiceyBundleLookup;
import ru.vyarus.dropwizard.guice.bundle.lookup.VoidBundleLookup;
import ru.vyarus.dropwizard.guice.injector.DefaultInjectorFactory;
import ru.vyarus.dropwizard.guice.injector.InjectorFactory;
import ru.vyarus.dropwizard.guice.injector.lookup.InjectorLookup;
import ru.vyarus.dropwizard.guice.module.GuiceBootstrapModule;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.context.debug.DiagnosticBundle;
import ru.vyarus.dropwizard.guice.module.context.debug.report.diagnostic.DiagnosticConfig;
import ru.vyarus.dropwizard.guice.module.context.debug.report.tree.ContextTreeConfig;
import ru.vyarus.dropwizard.guice.module.context.info.ItemInfo;
import ru.vyarus.dropwizard.guice.module.context.stat.Stat;
import ru.vyarus.dropwizard.guice.module.installer.CoreInstallersBundle;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.InstallersOptions;
import ru.vyarus.dropwizard.guice.module.installer.WebInstallersBundle;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.dropwizard.guice.module.installer.internal.CommandSupport;
import ru.vyarus.dropwizard.guice.module.installer.internal.ModulesSupport;
import ru.vyarus.dropwizard.guice.module.installer.scanner.ClasspathScanner;
import ru.vyarus.dropwizard.guice.module.installer.util.BundleSupport;
import ru.vyarus.dropwizard.guice.module.jersey.debug.HK2DebugBundle;
import ru.vyarus.dropwizard.guice.module.lifecycle.GuiceyLifecycleListener;
import ru.vyarus.dropwizard.guice.module.lifecycle.debug.DebugGuiceyLifecycle;
import ru.vyarus.dropwizard.guice.module.yaml.report.BindingsConfig;
import ru.vyarus.dropwizard.guice.module.yaml.report.DebugConfigBindings;

public final class GuiceBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private Injector injector;
    private final ConfigurationContext context = new ConfigurationContext();
    private InjectorFactory injectorFactory = new DefaultInjectorFactory();
    private GuiceyBundleLookup bundleLookup = new DefaultBundleLookup();
    private ClasspathScanner scanner;

    GuiceBundle() {
    }

    public void initialize(Bootstrap bootstrap) {
        boolean scanEnabled;
        Stopwatch timer = this.context.stat().timer(Stat.GuiceyTime);
        this.context.initPhaseStarted(bootstrap);
        String[] packages = (String[])this.context.option(GuiceyOptions.ScanPackages);
        boolean searchCommands = (Boolean)this.context.option(GuiceyOptions.SearchCommands);
        boolean bl = scanEnabled = packages.length > 0;
        if (searchCommands) {
            Preconditions.checkState((boolean)scanEnabled, (Object)"Commands search could not be performed, because auto scan was not activated");
        }
        List<Command> installed = null;
        if (scanEnabled) {
            this.scanner = new ClasspathScanner(Sets.newHashSet(Arrays.asList(packages)), this.context.stat());
            if (searchCommands) {
                installed = CommandSupport.registerCommands(bootstrap, this.scanner, this.context);
            }
        }
        this.context.lifecycle().initialization(bootstrap, installed);
        timer.stop();
    }

    public void run(T configuration, Environment environment) throws Exception {
        Stopwatch timer = this.context.stat().timer(Stat.GuiceyTime);
        this.context.runPhaseStarted((Configuration)configuration, environment);
        if (((Boolean)this.context.option(GuiceyOptions.UseCoreInstallers)).booleanValue()) {
            this.context.registerBundles(new CoreInstallersBundle());
        }
        this.configureFromBundles();
        this.context.registerModules(new Module[]{new GuiceBootstrapModule(this.scanner, this.context)});
        ModulesSupport.configureModules(this.context);
        this.createInjector(environment);
        this.afterInjectorCreation();
        this.context.lifecycle().applicationRun();
        timer.stop();
    }

    public Injector getInjector() {
        return (Injector)Preconditions.checkNotNull((Object)this.injector, (Object)"Guice not initialized");
    }

    private void configureFromBundles() {
        this.context.lifecycle().runPhase(this.context.getConfiguration(), this.context.getConfigurationTree(), this.context.getEnvironment());
        Stopwatch timer = this.context.stat().timer(Stat.BundleTime);
        Stopwatch resolutionTimer = this.context.stat().timer(Stat.BundleResolutionTime);
        if (((Boolean)this.context.option(GuiceyOptions.ConfigureFromDropwizardBundles)).booleanValue()) {
            this.context.registerDwBundles(BundleSupport.findBundles(this.context.getBootstrap(), GuiceyBundle.class));
        }
        this.context.registerLookupBundles(this.bundleLookup.lookup());
        resolutionTimer.stop();
        BundleSupport.processBundles(this.context);
        timer.stop();
    }

    private void createInjector(Environment environment) {
        Stopwatch timer = this.context.stat().timer(Stat.InjectorCreationTime);
        this.injector = this.injectorFactory.createInjector((Stage)this.context.option(GuiceyOptions.InjectorStage), ModulesSupport.prepareModules(this.context));
        environment.lifecycle().manage(InjectorLookup.registerInjector(this.context.getBootstrap().getApplication(), this.injector));
        timer.stop();
    }

    private void afterInjectorCreation() {
        CommandSupport.initCommands((List<Command>)this.context.getBootstrap().getCommands(), this.injector, this.context.stat());
        if (this.scanner != null) {
            this.scanner.cleanup();
        }
    }

    public static <T extends Configuration> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T extends Configuration> {
        private final GuiceBundle<T> bundle = new GuiceBundle();

        public Builder<T> listen(GuiceyLifecycleListener ... listeners) {
            ((GuiceBundle)this.bundle).context.lifecycle().register(listeners);
            return this;
        }

        public <K extends Enum> Builder<T> option(K option, Object value) {
            ((GuiceBundle)this.bundle).context.setOption(option, value);
            return this;
        }

        public <K extends Enum> Builder<T> options(Map<Enum, Object> options) {
            options.forEach((x$0, x$1) -> this.option((Enum)x$0, x$1));
            return this;
        }

        public Builder<T> injectorFactory(InjectorFactory injectorFactory) {
            ((GuiceBundle)this.bundle).injectorFactory = injectorFactory;
            return this;
        }

        public Builder<T> bundleLookup(GuiceyBundleLookup bundleLookup) {
            ((GuiceBundle)this.bundle).bundleLookup = bundleLookup;
            return this;
        }

        public Builder<T> disableBundleLookup() {
            return this.bundleLookup(new VoidBundleLookup());
        }

        public Builder<T> enableAutoConfig(String ... basePackages) {
            Preconditions.checkState((basePackages.length > 0 ? 1 : 0) != 0, (Object)"Specify at least one package to scan");
            return this.option(GuiceyOptions.ScanPackages, basePackages);
        }

        public Builder<T> modules(Module ... modules) {
            Preconditions.checkState((modules.length > 0 ? 1 : 0) != 0, (Object)"Specify at least one module");
            ((GuiceBundle)this.bundle).context.registerModules(modules);
            return this;
        }

        public Builder<T> modulesOverride(Module ... modules) {
            ((GuiceBundle)this.bundle).context.registerModulesOverride(modules);
            return this;
        }

        public Builder<T> searchCommands() {
            return this.option(GuiceyOptions.SearchCommands, true);
        }

        public Builder<T> noDefaultInstallers() {
            return this.option(GuiceyOptions.UseCoreInstallers, false);
        }

        public Builder<T> useWebInstallers() {
            ((GuiceBundle)this.bundle).context.registerBundles(new WebInstallersBundle());
            return this;
        }

        public Builder<T> noGuiceFilter() {
            return this.option(GuiceyOptions.GuiceFilterRegistration, EnumSet.noneOf(DispatcherType.class));
        }

        @SafeVarargs
        public final Builder<T> installers(Class<? extends FeatureInstaller> ... installers) {
            ((GuiceBundle)this.bundle).context.registerInstallers(installers);
            return this;
        }

        public Builder<T> extensions(Class<?> ... extensionClasses) {
            ((GuiceBundle)this.bundle).context.registerExtensions(extensionClasses);
            return this;
        }

        public Builder<T> bundles(GuiceyBundle ... bundles) {
            ((GuiceBundle)this.bundle).context.registerBundles(bundles);
            return this;
        }

        @SafeVarargs
        public final Builder<T> disableInstallers(Class<? extends FeatureInstaller> ... installers) {
            ((GuiceBundle)this.bundle).context.disableInstallers(installers);
            return this;
        }

        public final Builder<T> disableExtensions(Class<?> ... extensions) {
            ((GuiceBundle)this.bundle).context.disableExtensions(extensions);
            return this;
        }

        @SafeVarargs
        public final Builder<T> disableModules(Class<? extends Module> ... modules) {
            ((GuiceBundle)this.bundle).context.disableModules(modules);
            return this;
        }

        @SafeVarargs
        public final Builder<T> disableBundles(Class<? extends GuiceyBundle> ... bundles) {
            ((GuiceBundle)this.bundle).context.disableBundle(bundles);
            return this;
        }

        @SafeVarargs
        public final Builder<T> disable(Predicate<ItemInfo> ... predicates) {
            ((GuiceBundle)this.bundle).context.registerDisablePredicates(predicates);
            return this;
        }

        public Builder<T> configureFromDropwizardBundles() {
            return this.option(GuiceyOptions.ConfigureFromDropwizardBundles, true);
        }

        @Deprecated
        public Builder<T> bindConfigurationInterfaces() {
            return this.option(GuiceyOptions.BindConfigurationInterfaces, true);
        }

        public Builder<T> strictScopeControl() {
            ((GuiceBundle)this.bundle).context.registerBundles(new HK2DebugBundle());
            return this;
        }

        public Builder<T> useHK2ForJerseyExtensions() {
            this.option(InstallersOptions.JerseyExtensionsManagedByGuice, false);
            this.option(GuiceyOptions.UseHkBridge, true);
            return this;
        }

        public Builder<T> printDiagnosticInfo() {
            ((GuiceBundle)this.bundle).context.registerBundles(new DiagnosticBundle());
            return this;
        }

        public Builder<T> printAvailableInstallers() {
            ((GuiceBundle)this.bundle).context.registerBundles(DiagnosticBundle.builder().printConfiguration(new DiagnosticConfig().printInstallers().printNotUsedInstallers()).printContextTree(new ContextTreeConfig().hideCommands().hideDuplicateRegistrations().hideEmptyBundles().hideExtensions().hideModules()).build());
            return this;
        }

        public Builder<T> printConfigurationBindings() {
            return this.listen(new DebugConfigBindings(new BindingsConfig().showConfigurationTree().showNullValues()));
        }

        public Builder<T> printCustomConfigurationBindings() {
            return this.listen(new DebugConfigBindings(new BindingsConfig().showConfigurationTree().showNullValues().showCustomConfigOnly()));
        }

        public Builder<T> printLifecyclePhases() {
            return this.listen(new DebugGuiceyLifecycle(false));
        }

        public Builder<T> printLifecyclePhasesDetailed() {
            return this.listen(new DebugGuiceyLifecycle(true));
        }

        public GuiceBundle<T> build(Stage stage) {
            this.option(GuiceyOptions.InjectorStage, stage);
            return this.build();
        }

        public GuiceBundle<T> build() {
            ((GuiceBundle)this.bundle).context.runHooks(this);
            return this.bundle;
        }
    }
}

