/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.context.info.ItemInfo;

public final class ConfigurationInfo {
    private final Multimap<ConfigItem, Class<?>> itemsHolder = LinkedHashMultimap.create();
    private final Map<Class<?>, ItemInfo> detailsHolder = Maps.newHashMap();

    public ConfigurationInfo(ConfigurationContext context) {
        for (ConfigItem type : ConfigItem.values()) {
            for (Object item : context.getItems(type)) {
                Class<?> itemType = this.getType(item);
                this.itemsHolder.put((Object)type, itemType);
                this.detailsHolder.put(itemType, (ItemInfo)context.getInfo(item));
            }
        }
    }

    public <T> List<Class<T>> getItems(ConfigItem type) {
        Collection res = this.itemsHolder.get((Object)type);
        return res.isEmpty() ? Collections.emptyList() : Lists.newArrayList((Iterable)res);
    }

    public <T, K extends ItemInfo> List<Class<T>> getItems(ConfigItem type, Predicate<K> filter) {
        List<Class<T>> items = this.getItems(type);
        return this.filter(items, filter);
    }

    public List<Class<Object>> getItems(Predicate<ItemInfo> filter) {
        ArrayList items = Lists.newArrayList((Iterable)this.itemsHolder.values());
        return this.filter(items, filter);
    }

    public <T extends ItemInfo> T getInfo(Class<?> item) {
        return (T)this.detailsHolder.get(item);
    }

    private Class<?> getType(Object item) {
        return item instanceof Class ? (Class<?>)item : item.getClass();
    }

    private <T, K extends ItemInfo> List<Class<T>> filter(List<Class<T>> items, Predicate<K> filter) {
        return items.stream().filter(it -> filter.test(this.getInfo((Class<?>)it))).collect(Collectors.toList());
    }
}

