/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.ConfigScope;
import ru.vyarus.dropwizard.guice.module.context.info.BundleItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.ExtensionItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.ItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.ModuleItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.sign.DisableSupport;
import ru.vyarus.dropwizard.guice.module.context.info.sign.ScanSupport;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;

public final class Filters {
    private Filters() {
    }

    public static <T extends ItemInfo> Predicate<T> enabled() {
        return input -> !(input instanceof DisableSupport) || ((DisableSupport)((Object)input)).isEnabled();
    }

    public static <T extends ItemInfo> Predicate<T> disabledBy(Class<?> scope) {
        return input -> input instanceof DisableSupport && ((DisableSupport)((Object)input)).getDisabledBy().contains(scope);
    }

    public static <T extends ItemInfo> Predicate<T> fromScan() {
        return input -> input instanceof ScanSupport && ((ScanSupport)((Object)input)).isFromScan();
    }

    public static <T extends ItemInfo> Predicate<T> registrationScope(ConfigScope specialScope) {
        return Filters.registrationScope(specialScope.getType());
    }

    public static <T extends ItemInfo> Predicate<T> registrationScope(Class<?> scope) {
        return input -> scope.equals(input.getRegistrationScope());
    }

    public static <T extends ItemInfo> Predicate<T> registeredBy(ConfigScope specialScope) {
        return Filters.registeredBy(specialScope.getType());
    }

    public static <T extends ItemInfo> Predicate<T> registeredBy(Class<?> type) {
        return input -> input.getRegisteredBy().contains(type);
    }

    public static Predicate<ItemInfo> type(ConfigItem ... types) {
        List<ConfigItem> target = Arrays.asList(types);
        return input -> target.contains((Object)input.getItemType());
    }

    public static Predicate<BundleItemInfo> lookupBundles() {
        return BundleItemInfo::isFromLookup;
    }

    public static Predicate<BundleItemInfo> dwBundles() {
        return BundleItemInfo::isFromDwBundle;
    }

    public static Predicate<BundleItemInfo> transitiveBundles() {
        return BundleItemInfo::isTransitive;
    }

    public static Predicate<ExtensionItemInfo> installedBy(Class<? extends FeatureInstaller> type) {
        return input -> type.equals(input.getInstalledBy());
    }

    public static Predicate<ModuleItemInfo> overridingModule() {
        return ModuleItemInfo::isOverriding;
    }
}

