/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context.debug.report.stat;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.inject.Inject;
import javax.inject.Singleton;
import ru.vyarus.dropwizard.guice.module.GuiceyConfigurationInfo;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.Filters;
import ru.vyarus.dropwizard.guice.module.context.debug.report.ReportRenderer;
import ru.vyarus.dropwizard.guice.module.context.debug.util.TreeNode;
import ru.vyarus.dropwizard.guice.module.context.stat.Stat;
import ru.vyarus.dropwizard.guice.module.installer.install.JerseyInstaller;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

@Singleton
@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_INFERRED"})
public class StatsRenderer
implements ReportRenderer<Boolean> {
    private final GuiceyConfigurationInfo info;

    @Inject
    public StatsRenderer(GuiceyConfigurationInfo info) {
        this.info = info;
    }

    @Override
    public String renderReport(Boolean hideTiny) {
        TreeNode root = new TreeNode("GUICEY started in %s", this.info.getStats().humanTime(Stat.GuiceyTime));
        this.renderTimes(root, hideTiny);
        StringBuilder res = new StringBuilder().append(Reporter.NEWLINE).append(Reporter.NEWLINE);
        root.render(res);
        return res.toString();
    }

    private void renderTimes(TreeNode root, boolean hideTiny) {
        long remaining = this.info.getStats().time(Stat.GuiceyTime);
        double percent = (double)remaining / 100.0;
        remaining -= this.renderClasspathScanInfo(root, hideTiny, percent);
        remaining -= this.renderCommandsRegistration(root, hideTiny, percent);
        remaining -= this.renderBundlesProcessing(root, hideTiny, percent);
        remaining -= this.renderInjectorCreation(root, percent);
        if (this.show(hideTiny, remaining -= this.renderHkPart(root, hideTiny, percent))) {
            root.child("[%.2g%%] remaining %s ms", (double)remaining / percent, remaining);
        }
    }

    private long renderCommandsRegistration(TreeNode root, boolean hideTiny, double percent) {
        long command = this.info.getStats().time(Stat.CommandTime);
        if (this.show(hideTiny, command)) {
            TreeNode node = root.child("[%.2g%%] COMMANDS processed in %s", (double)command / percent, this.info.getStats().humanTime(Stat.CommandTime));
            int registered = this.info.getCommands().size();
            if (registered > 0) {
                node.child("registered %s commands", registered);
            }
        }
        return command;
    }

    private long renderBundlesProcessing(TreeNode root, boolean hideTiny, double percent) {
        long bundle = this.info.getStats().time(Stat.BundleTime);
        if (this.show(hideTiny, bundle)) {
            TreeNode node = root.child("[%.2g%%] BUNDLES processed in %s", (double)bundle / percent, this.info.getStats().humanTime(Stat.BundleTime));
            long resolved = this.info.getStats().time(Stat.BundleResolutionTime);
            if (this.show(hideTiny, resolved)) {
                node.child("%s resolved in %s", this.info.getBundlesFromDw().size() + this.info.getBundlesFromLookup().size(), this.info.getStats().humanTime(Stat.BundleResolutionTime));
            }
            node.child("%s processed", this.info.getBundles().size());
        }
        return bundle;
    }

    private long renderClasspathScanInfo(TreeNode root, boolean hideTiny, double percent) {
        long scan = this.info.getStats().time(Stat.ScanTime);
        if (this.show(hideTiny, scan)) {
            TreeNode node = root.child("[%.2g%%] CLASSPATH scanned in %s", (double)scan / percent, this.info.getStats().humanTime(Stat.ScanTime));
            int classes = this.info.getStats().count(Stat.ScanClassesCount);
            node.child("scanned %s classes", classes);
            int recognized = this.info.getData().getItems(Filters.fromScan()).size();
            node.child("recognized %s classes (%.2g%% of scanned)", recognized, Float.valueOf((float)recognized / ((float)classes / 100.0f)));
        }
        return scan;
    }

    private long renderInjectorCreation(TreeNode root, double percent) {
        long injector = this.info.getStats().time(Stat.InjectorCreationTime);
        TreeNode node = root.child("[%.2g%%] INJECTOR created in %s", (double)injector / percent, this.info.getStats().humanTime(Stat.InjectorCreationTime));
        node.child("installers prepared in %s", this.info.getStats().humanTime(Stat.InstallersTime));
        this.renderRecognition(node.child("extensions recognized in %s", this.info.getStats().humanTime(Stat.ExtensionsRecognitionTime)));
        node.child("%s extensions installed in %s", this.info.getExtensions().size(), this.info.getStats().humanTime(Stat.ExtensionsInstallationTime));
        return injector;
    }

    private void renderRecognition(TreeNode root) {
        root.child("using %s installers", this.info.getInstallers().size());
        int manual = this.info.getExtensions().size() - this.info.getExtensionsFromScan().size();
        root.child("from %s classes", this.info.getStats().count(Stat.ScanClassesCount) + manual);
    }

    private long renderHkPart(TreeNode root, boolean hideTiny, double percent) {
        long hk = this.info.getStats().time(Stat.HKTime);
        if (this.show(hideTiny, hk)) {
            TreeNode node = root.child("[%.2g%%] HK2 bridged in %s", (double)hk / percent, this.info.getStats().humanTime(Stat.HKTime));
            int installers = this.info.getData().getItems(ConfigItem.Installer, it -> JerseyInstaller.class.isAssignableFrom(it.getType())).size();
            if (installers > 0) {
                node.child("using %s jersey installers", installers);
                int extensions = this.info.getData().getItems(ConfigItem.Extension, it -> it.isEnabled() && JerseyInstaller.class.isAssignableFrom(it.getInstalledBy())).size();
                node.child("%s jersey extensions installed in %s", extensions, this.info.getStats().humanTime(Stat.JerseyInstallerTime));
            }
        }
        return hk;
    }

    private boolean show(boolean hideTiny, long value) {
        return !hideTiny || value > 0L;
    }
}

