/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context.debug.util;

import com.google.common.collect.Lists;
import java.util.List;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

public class TreeNode {
    private static final String THROUGH = "\u2502   ";
    private static final String LEAF = "\u251c\u2500\u2500 ";
    private static final String LAST_LEAF = "\u2514\u2500\u2500 ";
    private final String name;
    private final List<TreeNode> children = Lists.newArrayList();

    public TreeNode(String name, Object ... args) {
        this.name = String.format(name, args);
    }

    public TreeNode child(String name, Object ... args) {
        TreeNode node = new TreeNode(name, args);
        this.children.add(node);
        return node;
    }

    public void child(TreeNode node) {
        this.children.add(node);
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void render(StringBuilder res) {
        this.render(res, "", true, false);
    }

    private void render(StringBuilder res, String prefix, boolean isTail, boolean gapBefore) {
        if (prefix.isEmpty()) {
            res.append("    ").append(this.name).append(Reporter.NEWLINE);
        } else {
            if (gapBefore) {
                res.append(prefix).append(THROUGH).append(Reporter.NEWLINE);
            }
            res.append(prefix).append(isTail ? LAST_LEAF : LEAF).append(this.name).append(Reporter.NEWLINE);
        }
        for (int i = 0; i < this.children.size(); ++i) {
            boolean last = i == this.children.size() - 1;
            TreeNode child = this.children.get(i);
            boolean afterSubtree = i > 0 && !child.hasChildren() && this.children.get(i - 1).hasChildren();
            boolean gap = child.hasChildren() || afterSubtree;
            child.render(res, prefix + (isTail ? "    " : THROUGH), last, gap);
        }
    }
}

