/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context.stat;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import java.util.Map;
import ru.vyarus.dropwizard.guice.module.context.stat.Stat;

public final class StatsTracker {
    private final Map<Stat, Stopwatch> timers = Maps.newEnumMap(Stat.class);
    private final Map<Stat, Integer> counters = Maps.newEnumMap(Stat.class);

    public Stopwatch timer(Stat name) {
        Stopwatch watch = this.timers.computeIfAbsent(name, k -> Stopwatch.createUnstarted());
        watch.start();
        return watch;
    }

    public void count(Stat name, int count) {
        Integer value = this.counters.get((Object)name);
        value = value == null ? count : value + count;
        this.counters.put(name, value);
    }

    public void startHkTimer(Stat name) {
        this.timer(Stat.GuiceyTime);
        if (!Stat.HKTime.equals((Object)name)) {
            this.timer(Stat.HKTime);
        }
        this.timer(name);
    }

    public void stopHkTimer(Stat name) {
        this.timers.get((Object)Stat.GuiceyTime).stop();
        if (!Stat.HKTime.equals((Object)name)) {
            this.timers.get((Object)Stat.HKTime).stop();
        }
        this.timers.get((Object)name).stop();
    }

    public Map<Stat, Stopwatch> getTimers() {
        return this.timers;
    }

    public Map<Stat, Integer> getCounters() {
        return this.counters;
    }
}

