/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.context.info.ExtensionItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.impl.ExtensionItemInfoImpl;
import ru.vyarus.dropwizard.guice.module.context.option.Options;
import ru.vyarus.dropwizard.guice.module.context.stat.Stat;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.InstallersOptions;
import ru.vyarus.dropwizard.guice.module.installer.install.binding.BindingInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.binding.LazyBinding;
import ru.vyarus.dropwizard.guice.module.installer.internal.ExtensionsHolder;
import ru.vyarus.dropwizard.guice.module.installer.internal.FeatureInstallerExecutor;
import ru.vyarus.dropwizard.guice.module.installer.option.WithOptions;
import ru.vyarus.dropwizard.guice.module.installer.order.OrderComparator;
import ru.vyarus.dropwizard.guice.module.installer.scanner.ClassVisitor;
import ru.vyarus.dropwizard.guice.module.installer.scanner.ClasspathScanner;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.JerseyBinding;

public class InstallerModule
extends AbstractModule {
    private static final OrderComparator COMPARATOR = new OrderComparator();
    private final Logger logger = LoggerFactory.getLogger(InstallerModule.class);
    private final ClasspathScanner scanner;
    private final ConfigurationContext context;

    public InstallerModule(ClasspathScanner scanner, ConfigurationContext context) {
        this.scanner = scanner;
        this.context = context;
    }

    protected void configure() {
        this.bind(FeatureInstallerExecutor.class).asEagerSingleton();
        Stopwatch timer = this.context.stat().timer(Stat.InstallersTime);
        List<Class<? extends FeatureInstaller>> installerClasses = this.findInstallers();
        List<FeatureInstaller> installers = this.prepareInstallers(installerClasses);
        this.context.lifecycle().installersResolved(new ArrayList<FeatureInstaller>(installers), this.context.getDisabledInstallers());
        timer.stop();
        ExtensionsHolder holder = new ExtensionsHolder(installers, this.context.stat(), this.context.lifecycle());
        this.bind(ExtensionsHolder.class).toInstance((Object)holder);
        this.resolveExtensions(holder);
        this.context.finalizeConfiguration();
    }

    private List<Class<? extends FeatureInstaller>> findInstallers() {
        List<Object> installers;
        if (this.scanner != null) {
            installers = Lists.newArrayList();
            this.scanner.scan(new ClassVisitor(){

                @Override
                public void visit(Class<?> type) {
                    if (FeatureUtils.is(type, FeatureInstaller.class)) {
                        installers.add(type);
                    }
                }
            });
            installers.sort(Comparator.comparing(Class::getName));
            this.context.registerInstallersFromScan(installers);
        }
        installers = this.context.getEnabledInstallers();
        installers.sort(COMPARATOR);
        this.logger.debug("Found {} installers", (Object)installers.size());
        return installers;
    }

    private List<FeatureInstaller> prepareInstallers(List<Class<? extends FeatureInstaller>> installerClasses) {
        ArrayList installers = Lists.newArrayList();
        Options options = new Options(this.context.options());
        for (Class<? extends FeatureInstaller> installerClass : installerClasses) {
            try {
                FeatureInstaller installer = installerClass.newInstance();
                installers.add(installer);
                if (!WithOptions.class.isAssignableFrom(installerClass)) continue;
                ((WithOptions)((Object)installer)).setOptions(options);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to register installer " + installerClass.getName(), e);
            }
        }
        return installers;
    }

    private void resolveExtensions(ExtensionsHolder holder) {
        Stopwatch timer = this.context.stat().timer(Stat.ExtensionsRecognitionTime);
        boolean guiceFirstMode = (Boolean)this.context.option(InstallersOptions.JerseyExtensionsManagedByGuice);
        List<Class<?>> manual = this.context.getEnabledExtensions();
        for (Class<?> type2 : manual) {
            if (this.processType(type2, holder, guiceFirstMode, false)) continue;
            throw new IllegalStateException("No installer found for extension " + type2.getName() + ". Available installers: " + holder.getInstallerTypes().stream().map(FeatureUtils::getInstallerExtName).collect(Collectors.joining(", ")));
        }
        if (this.scanner != null) {
            this.scanner.scan(type -> {
                if (manual.contains(type)) {
                    this.context.getOrRegisterExtension(type, true);
                } else {
                    this.processType(type, holder, guiceFirstMode, true);
                }
            });
        }
        this.context.lifecycle().extensionsResolved(this.context.getEnabledExtensions(), this.context.getDisabledExtensions());
        timer.stop();
    }

    private boolean processType(Class<?> type, ExtensionsHolder holder, boolean guiceFirstMode, boolean fromScan) {
        boolean recognized;
        FeatureInstaller installer = this.findInstaller(type, holder);
        boolean bl = recognized = installer != null;
        if (recognized) {
            ExtensionItemInfoImpl info = this.context.getOrRegisterExtension(type, fromScan);
            info.setLazy(type.isAnnotationPresent(LazyBinding.class));
            info.setHk2Managed(JerseyBinding.isHK2Managed(type, guiceFirstMode));
            info.setInstalledBy(installer.getClass());
            if (!fromScan || this.context.isExtensionEnabled(type)) {
                this.bindExtension(info, installer, holder);
            }
        }
        return recognized;
    }

    private FeatureInstaller findInstaller(Class<?> type, ExtensionsHolder holder) {
        for (FeatureInstaller installer : holder.getInstallers()) {
            if (!installer.matches(type)) continue;
            return installer;
        }
        return null;
    }

    private void bindExtension(ExtensionItemInfo item, FeatureInstaller installer, ExtensionsHolder holder) {
        Class<?> installerClass = installer.getClass();
        Class<?> type = item.getType();
        holder.register(installerClass, type);
        if (installer instanceof BindingInstaller) {
            ((BindingInstaller)((Object)installer)).install(this.binder(), type, item.isLazy());
        } else if (!item.isLazy()) {
            this.binder().bind(type);
        }
    }
}

