/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.bundle;

import com.google.common.base.Preconditions;
import com.google.inject.Module;
import io.dropwizard.Application;
import io.dropwizard.Configuration;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.Arrays;
import java.util.List;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.dropwizard.guice.module.lifecycle.GuiceyLifecycleListener;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigurationTree;

public class GuiceyBootstrap {
    private final ConfigurationContext context;
    private final List<GuiceyBundle> iterationBundles;

    public GuiceyBootstrap(ConfigurationContext context, List<GuiceyBundle> iterationBundles) {
        this.context = context;
        this.iterationBundles = iterationBundles;
    }

    public Bootstrap bootstrap() {
        return this.context.getBootstrap();
    }

    public <T extends Configuration> T configuration() {
        return (T)this.context.getConfiguration();
    }

    public <T> T configuration(String yamlPath) {
        return this.configurationTree().valueByPath(yamlPath);
    }

    public <T, K extends T> K configuration(Class<T> type) {
        return this.configurationTree().valueByUniqueDeclaredType(type);
    }

    public <T> List<? extends T> configurations(Class<T> type) {
        return this.configurationTree().valuesByType(type);
    }

    public ConfigurationTree configurationTree() {
        return this.context.getConfigurationTree();
    }

    public Environment environment() {
        return this.context.getEnvironment();
    }

    public Application application() {
        return this.context.getBootstrap().getApplication();
    }

    public <V, T extends Enum> V option(T option) {
        return this.context.option(option);
    }

    public GuiceyBootstrap modules(Module ... modules) {
        Preconditions.checkState((modules.length > 0 ? 1 : 0) != 0, (Object)"Specify at least one module");
        this.context.registerModules(modules);
        return this;
    }

    public GuiceyBootstrap modulesOverride(Module ... modules) {
        this.context.registerModulesOverride(modules);
        return this;
    }

    @SafeVarargs
    public final GuiceyBootstrap installers(Class<? extends FeatureInstaller> ... installers) {
        this.context.registerInstallers(installers);
        return this;
    }

    public GuiceyBootstrap extensions(Class<?> ... extensionClasses) {
        this.context.registerExtensions(extensionClasses);
        return this;
    }

    public GuiceyBootstrap bundles(GuiceyBundle ... bundles) {
        this.context.registerBundles(bundles);
        this.iterationBundles.addAll(Arrays.asList(bundles));
        return this;
    }

    @SafeVarargs
    public final GuiceyBootstrap disableInstallers(Class<? extends FeatureInstaller> ... installers) {
        this.context.disableInstallers(installers);
        return this;
    }

    public final GuiceyBootstrap disableExtensions(Class<?> ... extensions) {
        this.context.disableExtensions(extensions);
        return this;
    }

    @SafeVarargs
    public final GuiceyBootstrap disableModules(Class<? extends Module> ... modules) {
        this.context.disableModules(modules);
        return this;
    }

    public GuiceyBootstrap listen(GuiceyLifecycleListener ... listeners) {
        this.context.lifecycle().register(listeners);
        return this;
    }
}

