/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.feature.eager;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.feature.eager.EagerSingleton;
import ru.vyarus.dropwizard.guice.module.installer.install.binding.BindingInstaller;
import ru.vyarus.dropwizard.guice.module.installer.order.Order;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

@Order(value=50)
public class EagerSingletonInstaller
implements FeatureInstaller<Object>,
BindingInstaller {
    private final Reporter reporter = new Reporter(EagerSingletonInstaller.class, "eager singletons =");

    @Override
    public boolean matches(Class<?> type) {
        return FeatureUtils.hasAnnotation(type, EagerSingleton.class);
    }

    @Override
    public <T> void install(Binder binder, Class<? extends T> type, boolean lazy) {
        Preconditions.checkArgument((!lazy ? 1 : 0) != 0, (String)"Eager bean can't be annotated as lazy: %s", (Object)type.getName());
        binder.bind(type).asEagerSingleton();
        this.reporter.line("(%s)", type.getName());
    }

    @Override
    public void report() {
        this.reporter.report();
    }
}

