/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.util;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.dropwizard.setup.Bootstrap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBootstrap;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;

public final class BundleSupport {
    private BundleSupport() {
    }

    public static void processBundles(ConfigurationContext context) {
        List<GuiceyBundle> bundles = context.getEnabledBundles();
        ArrayList installedBundles = Lists.newArrayList();
        GuiceyBootstrap guiceyBootstrap = new GuiceyBootstrap(context, bundles);
        while (!bundles.isEmpty()) {
            ArrayList processingBundles = Lists.newArrayList(BundleSupport.removeDuplicates(bundles));
            bundles.clear();
            for (GuiceyBundle bundle : BundleSupport.removeTypes(processingBundles, installedBundles)) {
                Class<?> bundleType = bundle.getClass();
                Preconditions.checkState((!installedBundles.contains(bundleType) ? 1 : 0) != 0, (String)"State error: duplicate bundle '%s' registration", (Object)bundleType.getName());
                if (context.isBundleEnabled(bundleType)) {
                    context.setScope(bundleType);
                    bundle.initialize(guiceyBootstrap);
                    context.closeScope();
                }
                installedBundles.add(bundleType);
            }
        }
        context.lifecycle().bundlesProcessed(context.getEnabledBundles(), context.getDisabledBundles());
    }

    public static <T> List<T> removeDuplicates(List<T> list) {
        ArrayList registered = Lists.newArrayList();
        Iterator<T> it = list.iterator();
        while (it.hasNext()) {
            Class<?> type = it.next().getClass();
            if (registered.contains(type)) {
                it.remove();
                continue;
            }
            registered.add(type);
        }
        return list;
    }

    public static <T> List<T> removeTypes(List<T> list, List<Class<? extends T>> filter) {
        Iterator<T> it = list.iterator();
        while (it.hasNext()) {
            Class<?> type = it.next().getClass();
            if (!filter.contains(type)) continue;
            it.remove();
        }
        return list;
    }

    public static <T> List<T> findBundles(Bootstrap bootstrap, Class<T> type) {
        ArrayList bundles = Lists.newArrayList(BundleSupport.resolveBundles(bootstrap, "bundles"));
        bundles.addAll(BundleSupport.resolveBundles(bootstrap, "configuredBundles"));
        bundles.removeIf(o -> !type.isAssignableFrom(o.getClass()));
        return bundles;
    }

    private static <T> List<T> resolveBundles(Bootstrap bootstrap, String field) {
        try {
            Field declaredField = Bootstrap.class.getDeclaredField(field);
            declaredField.setAccessible(true);
            List res = (List)declaredField.get(bootstrap);
            declaredField.setAccessible(false);
            return (List)MoreObjects.firstNonNull((Object)res, Collections.emptyList());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to resolve bootstrap field " + field, e);
        }
    }
}

