/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.util;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.binder.ScopedBindingBuilder;
import java.lang.reflect.Type;
import java.util.List;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.hk2.utilities.binding.ServiceBindingBuilder;
import org.glassfish.hk2.utilities.reflection.ParameterizedTypeImpl;
import ru.vyarus.dropwizard.guice.module.installer.feature.jersey.GuiceManaged;
import ru.vyarus.dropwizard.guice.module.installer.feature.jersey.HK2Managed;
import ru.vyarus.dropwizard.guice.module.jersey.support.GuiceComponentFactory;
import ru.vyarus.dropwizard.guice.module.jersey.support.JerseyComponentProvider;
import ru.vyarus.dropwizard.guice.module.jersey.support.LazyGuiceFactory;
import ru.vyarus.java.generics.resolver.GenericsResolver;
import ru.vyarus.java.generics.resolver.context.GenericsContext;

public final class JerseyBinding {
    private JerseyBinding() {
    }

    public static boolean isBridgeAvailable() {
        try {
            Class.forName("org.jvnet.hk2.guice.bridge.api.GuiceBridge");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static boolean isHK2Managed(Class<?> type, boolean guiceFirstMode) {
        return guiceFirstMode ? type.isAnnotationPresent(HK2Managed.class) : !type.isAnnotationPresent(GuiceManaged.class);
    }

    public static void bindComponent(AbstractBinder binder, Injector injector, Class<?> type, boolean hkManaged, boolean singleton) {
        if (hkManaged) {
            JerseyBinding.optionalSingleton(binder.bindAsContract(type), singleton);
        } else {
            JerseyBinding.optionalSingleton(binder.bindFactory(new GuiceComponentFactory(injector, type)).to(type), singleton);
        }
    }

    public static <T> void bindFactory(AbstractBinder binder, Injector injector, Class<?> type, boolean hkManaged, boolean singleton) {
        Class res = GenericsResolver.resolve(type, (Class[])new Class[0]).type(Factory.class).generic(0);
        if (hkManaged) {
            JerseyBinding.optionalSingleton(singleton ? binder.bindFactory(type, Singleton.class).to(type).to(res) : binder.bindFactory(type).to(type).to(res), singleton);
        } else {
            binder.bindFactory(new LazyGuiceFactory(injector, type)).to(res);
            JerseyBinding.optionalSingleton(binder.bindFactory(new GuiceComponentFactory(injector, type)).to(type), singleton);
        }
    }

    public static void bindSpecificComponent(AbstractBinder binder, Injector injector, Class<?> type, Class<?> specificType, boolean hkManaged, boolean singleton) {
        ParameterizedTypeImpl bindingType;
        GenericsContext context = GenericsResolver.resolve(type, (Class[])new Class[0]).type(specificType);
        List genericTypes = context.genericTypes();
        Type[] generics = genericTypes.toArray(new Type[0]);
        ParameterizedTypeImpl parameterizedTypeImpl = bindingType = generics.length > 0 ? new ParameterizedTypeImpl((Type)specificType, generics) : specificType;
        if (hkManaged) {
            JerseyBinding.optionalSingleton(binder.bind(type).to(type).to((Type)bindingType), singleton);
        } else if (InjectionResolver.class.equals((Object)specificType)) {
            JerseyBinding.optionalSingleton(binder.bindFactory(new GuiceComponentFactory(injector, type)).to(type), singleton);
            JerseyBinding.optionalSingleton(binder.bindAsContract(type).to((Type)bindingType), singleton);
        } else {
            JerseyBinding.optionalSingleton(binder.bindFactory(new GuiceComponentFactory(injector, type)).to(type).to((Type)bindingType), singleton);
        }
    }

    public static <T> ScopedBindingBuilder bindJerseyComponent(Binder binder, Provider<Injector> provider, Class<T> type) {
        return binder.bind(type).toProvider(new JerseyComponentProvider<T>(provider, type));
    }

    private static void optionalSingleton(ServiceBindingBuilder<?> binding, boolean singleton) {
        if (singleton) {
            binding.in(Singleton.class);
        }
    }
}

